/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.lockme.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.lockme.Lock;
import kd.bos.lockme.db.DBLockInfo;
import kd.bos.lockme.db.LockDataSourceManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ThreadLocals;
import kd.bos.util.resource.Resources;

public class DBLocker
implements Lock {
    private static final String BOS_LOCKME = "bos-lockme";
    private static final String KSQL_TRANSLATE_ERROR = "Ksql translate error\uff1a = ";
    private static String tableName = "T_CORE_DLOCK";
    private static String createTableSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '" + tableName + "') CREATE TABLE " + tableName + " (FLOCKKEY varchar(255) NOT NULL PRIMARY KEY)";
    private static String insertSql = "INSERT INTO " + tableName + "(FLOCKKEY) VALUES(?)";
    private static Map<String, Boolean> accountCreateMap = new ConcurrentHashMap<String, Boolean>();
    private static Map<String, DataSource> accountDataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private static ThreadLocal<Map<String, DBLockInfo>> th = ThreadLocals.create();
    private static final Log log = LogFactory.getLog(DBLocker.class);
    private String lockKey;
    private String accoutId;
    private boolean isReentrant;
    private Connection con = null;

    public DBLocker(String lockKey, boolean isReentrant) {
        this.lockKey = lockKey;
        this.isReentrant = isReentrant;
        this.accoutId = RequestContext.get().getAccountId();
        if (!accountDataSourceMap.containsKey(this.accoutId)) {
            accountDataSourceMap.put(this.accoutId, LockDataSourceManager.getDataSource());
        }
    }

    @Override
    public void lock() {
        this.getLock(0);
    }

    @Override
    public boolean tryLockInSecond(int second) {
        if (second <= 0) {
            second = 1;
        }
        return this.getLock(second);
    }

    private boolean getLock(int second) {
        if (this.isReentrant) {
            DBLockInfo dbLockInfo;
            boolean isGetLock = false;
            Map<String, DBLockInfo> map = th.get();
            if (map == null) {
                map = new HashMap<String, DBLockInfo>();
            }
            if ((dbLockInfo = map.get(this.lockKey)) != null) {
                this.con = dbLockInfo.getCon();
                isGetLock = true;
            } else {
                try {
                    this.con = accountDataSourceMap.get(this.accoutId).getConnection();
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{Resources.getString((String)"\u83b7\u5f97\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:", (String)"DBLocker_0", (String)BOS_LOCKME, (Object[])new Object[0]) + e.getMessage()});
                }
                dbLockInfo = new DBLockInfo(this.con, 0);
                isGetLock = this.getLock1(second);
            }
            if (isGetLock) {
                dbLockInfo.setReentrantCount(dbLockInfo.getReentrantCount() + 1);
                map.put(this.lockKey, dbLockInfo);
                th.set(map);
            }
            return isGetLock;
        }
        if (this.con != null) {
            return true;
        }
        try {
            this.con = accountDataSourceMap.get(this.accoutId).getConnection();
        }
        catch (SQLException e) {
            throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{Resources.getString((String)"\u83b7\u5f97\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:", (String)"DBLocker_0", (String)BOS_LOCKME, (Object[])new Object[0]) + e.getMessage()});
        }
        return this.getLock1(second);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLock1(int second) {
        boolean result = true;
        DBLocker.createTable(this.accoutId);
        Statement prst = null;
        try {
            this.con.setAutoCommit(false);
            prst = this.con.prepareStatement(DBLocker.getDialectSql(insertSql));
            prst.setQueryTimeout(second);
            prst.setString(1, this.lockKey);
            prst.execute();
        }
        catch (SQLException e) {
            try {
                this.con.rollback();
            }
            catch (SQLException e1) {
                log.error((Throwable)e1);
            }
            result = false;
        }
        finally {
            try {
                if (prst != null) {
                    prst.close();
                }
                this.con.close();
            }
            catch (SQLException e) {
                log.error((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public void unlock() {
        if (this.isReentrant) {
            Map<String, DBLockInfo> map = th.get();
            DBLockInfo dbLockInfo = map.get(this.lockKey);
            if (dbLockInfo != null) {
                int reentrantCount = dbLockInfo.getReentrantCount() - 1;
                if (reentrantCount == 0) {
                    this.unlock1();
                    map.remove(this.lockKey);
                } else {
                    dbLockInfo.setReentrantCount(reentrantCount);
                    map.put(this.lockKey, dbLockInfo);
                }
                th.set(map);
            }
        } else {
            this.unlock1();
        }
    }

    @Override
    public void close() {
        this.unlock();
    }

    private void unlock1() {
        if (this.con != null) {
            try {
                this.con.rollback();
            }
            catch (SQLException e) {
                log.error((Throwable)e);
            }
            finally {
                try {
                    this.con.close();
                }
                catch (SQLException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    private static String getDialectSql(String ksql) {
        if (LockDataSourceManager.isAloneDB()) {
            String resultSql = null;
            String dbType = LockDataSourceManager.getAloneDBConfig().get("dbType");
            if ("mysql".equalsIgnoreCase(dbType)) {
                try {
                    resultSql = TransUtil.translate((String)ksql, (int)6, null, null, (boolean)true);
                }
                catch (SqlTranslateException e) {
                    throw new KDException(BosErrorCode.sQL, new Object[]{KSQL_TRANSLATE_ERROR + ksql + "," + e.getMessage()});
                }
            } else if ("oracle".equalsIgnoreCase(dbType)) {
                try {
                    resultSql = TransUtil.translate((String)ksql, (int)2, null, null, (boolean)true);
                }
                catch (SqlTranslateException e) {
                    throw new KDException(BosErrorCode.sQL, new Object[]{KSQL_TRANSLATE_ERROR + ksql + "," + e.getMessage()});
                }
            } else if ("postgresql".equalsIgnoreCase(dbType)) {
                try {
                    resultSql = TransUtil.translate((String)ksql, (int)5, null, null, (boolean)true);
                }
                catch (SqlTranslateException e) {
                    throw new KDException(BosErrorCode.sQL, new Object[]{KSQL_TRANSLATE_ERROR + ksql + "," + e.getMessage()});
                }
            } else {
                throw new KDException(BosErrorCode.sQL, new Object[]{Resources.getString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1adbType = ", (String)"DBLocker_1", (String)BOS_LOCKME, (Object[])new Object[0]) + dbType});
            }
            return resultSql;
        }
        return ksql;
    }

    private static synchronized void createTable(String accoutIdStr) {
        if (accountCreateMap.get(accoutIdStr) != null) {
            Statement st = null;
            try (Connection connection = accountDataSourceMap.get(accoutIdStr).getConnection();){
                st = connection.createStatement();
                st.execute(DBLocker.getDialectSql(createTableSql));
                accountCreateMap.put(accoutIdStr, true);
            }
            catch (SQLException e) {
                throw new KDException(BosErrorCode.sQL, new Object[]{Resources.getString((String)"\u6267\u884csql\u51fa\u9519\uff1a", (String)"DBLocker_2", (String)BOS_LOCKME, (Object[])new Object[0]) + createTableSql + "," + e.getMessage()});
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (SQLException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }
}

