/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.instance;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.instance.AppCloudMapping;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.PropertiesUtil;
import kd.bos.util.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster {
    private static Logger LOG = LoggerFactory.getLogger(PropertiesUtil.class);
    private static Map<String, Set<String>> clusterAppIds = new ConcurrentHashMap<String, Set<String>>(1);
    private static Map<String, HashMultimap<String, String>> appCloudMapping = new HashMap<String, HashMultimap<String, String>>(2);
    private static Map<String, String> mapingCommonInAllAccount = new HashMap<String, String>(1);
    private static AtomicBoolean appCloudMappingInited = new AtomicBoolean(false);
    private static Set<String> cloudDeployAloneAppSet = new HashSet<String>(1);

    private static Set<String> initDeployCloudAppSet() {
        String appdisDeployAloneFromCloud = SystemProperties.getWithEnv("appIds.excludeFromCloudNode");
        HashSet<String> _cloudDeployAppSet = new HashSet<String>(1);
        if (appdisDeployAloneFromCloud != null) {
            String[] appidsDeployAlone;
            for (String appidDA : appidsDeployAlone = appdisDeployAloneFromCloud.split(",|;")) {
                _cloudDeployAppSet.add(appidDA);
            }
        }
        return _cloudDeployAppSet;
    }

    public static RegiestAppids getClusterRegiestAppIds() {
        String strAppIds = System.getProperty("registedAppIds");
        RegiestAppids regAppids = new RegiestAppids();
        if (strAppIds != null) {
            Set<String> appIds = clusterAppIds.get(strAppIds);
            if (appIds == null) {
                String[] arrayAppids = strAppIds.split(",");
                appIds = new HashSet<String>(arrayAppids.length);
                for (String id : arrayAppids) {
                    appIds.add(id);
                }
                if (clusterAppIds.size() > 10) {
                    clusterAppIds.clear();
                }
                clusterAppIds.put(strAppIds, appIds);
                regAppids.fromcache = false;
            } else {
                regAppids.fromcache = true;
            }
            regAppids.appids = Collections.unmodifiableSet(appIds);
        }
        return regAppids;
    }

    protected static Map<String, HashMultimap<String, String>> getAppCloudMapping() {
        if (appCloudMappingInited.compareAndSet(false, true)) {
            appCloudMapping = Cluster.loadAppCloudMapping();
            appCloudMapping.forEach((account, m) -> System.setProperty("cloud--appCloudMapping-" + account, m.toString()));
        }
        return appCloudMapping;
    }

    public static Map<String, String> getCloudAppidMapping() {
        Map<String, HashMultimap<String, String>> m = Cluster.getAppCloudMapping();
        HashMap<String, String> ret = new HashMap<String, String>(2);
        m.forEach((k, v) -> v.forEach((cloud, appid) -> ret.put((String)appid, (String)cloud)));
        return ret;
    }

    public static String getCloudByApp(String appid, String accountId) {
        if (appid == null) {
            return null;
        }
        if (cloudDeployAloneAppSet.contains(appid)) {
            return null;
        }
        if (accountId == null && !mapingCommonInAllAccount.isEmpty()) {
            return mapingCommonInAllAccount.get(appid);
        }
        Map<String, HashMultimap<String, String>> mapping = Cluster.getAppCloudMapping();
        HashMultimap<String, String> hmmap = mapping.get(accountId);
        if (hmmap == null) {
            return mapingCommonInAllAccount == null ? null : mapingCommonInAllAccount.get(appid);
        }
        for (Map.Entry entry : hmmap.entries()) {
            if (!appid.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private static Map<String, HashMultimap<String, String>> loadAppCloudMapping() {
        ServiceLoader<AppCloudMapping> loaders = ServiceLoader.load(AppCloudMapping.class);
        HashMap<String, HashMultimap<String, String>> mapingMap = new HashMap<String, HashMultimap<String, String>>(2);
        Map<String, String> mapingcommon = null;
        for (AppCloudMapping loader : loaders) {
            Map<String, HashMultimap<String, String>> m = null;
            try {
                m = loader.getAppidsInClouds();
                if (m == null || m.isEmpty()) {
                    throw new Exception(loader.getClass().getName() + " getAppIdsInClouds is empty");
                }
            }
            catch (Error | Exception e) {
                LOG.error("Appstore loadAppCloudMapping exception,Execute System.exit(-1), Starting to exit the service)", e);
                e.printStackTrace();
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                System.exit(-1);
            }
            if (m == null) continue;
            for (Map.Entry<String, HashMultimap<String, String>> entryM : m.entrySet()) {
                String k = entryM.getKey();
                HashMultimap<String, String> v = entryM.getValue();
                HashMultimap hmmap = mapingMap.computeIfAbsent(k, key -> HashMultimap.create());
                hmmap.putAll(v);
                HashMap<String, String> _mapingcommon = new HashMap<String, String>(2);
                for (Map.Entry entry : v.entries()) {
                    String cloud = (String)entry.getKey();
                    String appid = (String)entry.getValue();
                    _mapingcommon.put(appid, cloud);
                }
                if (mapingcommon == null) {
                    mapingcommon = _mapingcommon;
                    continue;
                }
                mapingcommon = Maps.difference(mapingcommon, _mapingcommon).entriesInCommon();
            }
        }
        if (mapingcommon != null) {
            mapingCommonInAllAccount = mapingcommon;
        }
        return mapingMap;
    }

    static {
        try {
            cloudDeployAloneAppSet = Cluster.initDeployCloudAppSet();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConfigurationUtil.observeChange("appIds.excludeFromCloudNode", new ConfigurationChangeListener(){

            @Override
            public void onChange(Object key, Object newValue) {
                cloudDeployAloneAppSet = Cluster.initDeployCloudAppSet();
            }
        });
    }

    public static class RegiestAppids {
        private boolean fromcache = false;
        private Set<String> appids = Collections.emptySet();

        public boolean isFromcache() {
            return this.fromcache;
        }

        public Set<String> getAppids() {
            return this.appids;
        }
    }
}

