/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.lang;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import com.hankcs.hanlp.dictionary.py.PinyinDictionary;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class HZPinyin {
    @Deprecated
    public static void putUncommonWord(char cnWord, String spell) {
    }

    public static String getFullSpell(String cn) throws UnsupportedEncodingException {
        return HZPinyin.convertToPinyinString(cn, " ", false, null);
    }

    public static String getFullSpell(String cn, String separator) throws UnsupportedEncodingException {
        return HZPinyin.convertToPinyinString(cn, separator, false, null);
    }

    public static String getFullSpell(String cn, Map<Character, String> pinyinMap) throws UnsupportedEncodingException {
        return HZPinyin.convertToPinyinString(cn, " ", false, pinyinMap);
    }

    public static String getFullSpell(String cn, Map<Character, String> pinyinMap, String separator) throws UnsupportedEncodingException {
        return HZPinyin.convertToPinyinString(cn, separator, false, pinyinMap);
    }

    public static String getFirstSpell(String cn) throws UnsupportedEncodingException {
        return HZPinyin.getFirstSpell(cn, null);
    }

    public static String getFirstSpell(String cn, Map<Character, String> pinyinMap) throws UnsupportedEncodingException {
        return HZPinyin.convertToPinyinFirstCharString(cn, true);
    }

    private static String convertToPinyinString(String text, String separator, boolean remainNone, Map<Character, String> pinyinMap) {
        if (StringUtils.isEmpty(text)) {
            return "";
        }
        List pinyinList = PinyinDictionary.convertToPinyin((String)text, (boolean)true);
        int length = pinyinList.size();
        StringBuilder sb = new StringBuilder(length * (5 + separator.length()));
        int i = 1;
        for (Pinyin pinyin : pinyinList) {
            char ch;
            String preDefined;
            if (pinyinMap != null && (preDefined = pinyinMap.get(Character.valueOf(ch = text.charAt(i - 1)))) != null) {
                sb.append(preDefined);
                ++i;
                continue;
            }
            if (pinyin == Pinyin.none5 && !remainNone) {
                if (i == 1) {
                    sb.append(text.charAt(i - 1));
                } else if (StringUtils.isEmpty(separator)) {
                    sb.append(text.charAt(i - 1));
                } else {
                    sb.setCharAt(sb.length() - 1, text.charAt(i - 1));
                }
            } else {
                sb.append(pinyin.getPinyinWithoutTone());
            }
            if (i < length) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    private static String convertToPinyinFirstCharString(String text, boolean remainNone) {
        if (StringUtils.isEmpty(text)) {
            return "";
        }
        List pinyinList = PinyinDictionary.convertToPinyin((String)text, (boolean)remainNone);
        int length = pinyinList.size();
        StringBuilder sb = new StringBuilder(length);
        int i = 1;
        for (Pinyin pinyin : pinyinList) {
            char ch = pinyin.getFirstChar();
            if (ch == ' ') {
                sb.append(text.charAt(i - 1));
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    static {
        HanLP.Config.SYTDictionaryPath = "data/dictionary/pinyin/SYTDictionary.txt";
        HanLP.Config.PinyinDictionaryPath = "data/dictionary/pinyin/pinyin.txt";
    }
}

