/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.thread;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.SafeLogUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class OutOfMemoryObserver {
    private static AtomicInteger count = new AtomicInteger();
    private static OutOfMemoryError _outOfMemoryError = null;
    private static Info info;
    private static int outCount;

    public static void onOutOfMemory(OutOfMemoryError outOfMemoryError) {
        if (_outOfMemoryError == null) {
            _outOfMemoryError = outOfMemoryError;
            info = new Info();
            Map rcinfo = (Map)ThreadTruck.get("rcinfo");
            if (rcinfo != null) {
                OutOfMemoryObserver.info.traceid = (String)rcinfo.get("traceId");
            }
        }
        count.incrementAndGet();
        if (outCount++ < 5) {
            String stacktrace = ExceptionUtils.getStackTrace((Throwable)outOfMemoryError);
            System.setProperty("OOM_" + outCount, stacktrace);
            SafeLogUtils.error(OutOfMemoryObserver.class, "OOM_" + outCount, outOfMemoryError);
        }
    }

    public static void onThrowable(Throwable e) {
        int count = 0;
        while (e != null && count++ < 15) {
            if (e instanceof OutOfMemoryError) {
                OutOfMemoryObserver.onOutOfMemory((OutOfMemoryError)e);
                continue;
            }
            e = e.getCause();
        }
    }

    public static boolean hasOOM() {
        return count.get() > 0;
    }

    public static int getCount() {
        return count.get();
    }

    public static String getFirstOOMStack() {
        if (_outOfMemoryError != null) {
            return info + ",[stacktrace] " + ExceptionUtils.getStackTrace((Throwable)_outOfMemoryError);
        }
        return null;
    }

    static {
        outCount = 0;
    }

    static class Info {
        String traceid;
        String time;

        Info() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.time = sdf.format(new Date());
        }

        public String toString() {
            return String.format("[time]%s,[traceId]%s ", this.time, this.traceid);
        }
    }
}

