/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.thread;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RunningThreadManage {
    private static Map<Thread, Long> runningThreads = new ConcurrentHashMap<Thread, Long>(2);

    public static void begin() {
        runningThreads.put(Thread.currentThread(), System.currentTimeMillis());
    }

    public static void end() {
        runningThreads.remove(Thread.currentThread());
    }

    public static int runningCount() {
        return runningThreads.size();
    }

    public static int longRunningCount(int seconds) {
        int count = 0;
        long before = System.currentTimeMillis() - (long)(seconds * 1000);
        for (Map.Entry<Thread, Long> entry : runningThreads.entrySet()) {
            if (entry.getValue() >= before) continue;
            ++count;
        }
        return count;
    }

    public static String getRunningThread() {
        StringBuilder sb = new StringBuilder();
        sb.append("  [");
        runningThreads.forEach((t, v) -> sb.append(t.getName()).append(","));
        sb.append("  ]");
        return sb.toString();
    }

    public static Set<Long> getRunningThreadIds() {
        HashSet<Long> ids = new HashSet<Long>(8);
        runningThreads.forEach((t, v) -> ids.add(t.getId()));
        return ids;
    }
}

