/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.thread;

import kd.bos.thread.RunningThreadManage;
import kd.bos.thread.ThreadTruck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetThreadName
implements AutoCloseable {
    private static Logger log = LoggerFactory.getLogger(SetThreadName.class);
    private static ThreadLocal<SetThreadName> thSetName = new ThreadLocal();
    private static final String PREFIX_SERVER_THREAD_NAME = "RpcRequest";
    private static final String traceIdLogEnable = "gov.trace.traceid.log.enable";
    private String originName;
    private String startName;

    public static void start() {
        SetThreadName origin = thSetName.get();
        if (origin != null) {
            origin.close();
        }
        thSetName.set(new SetThreadName());
        RunningThreadManage.begin();
    }

    public static void end() {
        SetThreadName setName = thSetName.get();
        if (setName != null) {
            setName.close();
        }
    }

    public SetThreadName() {
        this.init();
    }

    public void init() {
        this.originName = Thread.currentThread().getName();
        this.startName = this.originName + "//time:" + System.currentTimeMillis();
        Thread.currentThread().setName(this.startName);
    }

    @Override
    public void close() {
        Thread.currentThread().setName(this.originName);
        RunningThreadManage.end();
    }

    public static void setTraceId(String traceId) {
        SetThreadName tn = thSetName.get();
        if (tn != null) {
            String currentThreadName;
            if (traceId != null && !traceId.equals(ThreadTruck.get("apm.traceid.string")) && Boolean.getBoolean(traceIdLogEnable)) {
                log.warn("\u5f53\u524dTraceId\u5df2\u5b58\u5728\u4e3a{}, \u65b0TraceId\u4e3a\uff1a {}, \u8c03\u7528\u5806\u6808\u4e3a", new Object[]{ThreadTruck.get("apm.traceid.string"), traceId, new Exception()});
            }
            if (((currentThreadName = Thread.currentThread().getName()).contains("http-") || currentThreadName.contains(PREFIX_SERVER_THREAD_NAME)) && currentThreadName.contains("traceId")) {
                if (Boolean.getBoolean(traceIdLogEnable)) {
                    log.warn("\u7ebf\u7a0b\u540d\u5df2\u5305\u542bTraceId\uff0c\u65e0\u9700\u91cd\u5199,\u88ab\u91cd\u5199\u5806\u6808\u4e3a\uff1a {}", (Throwable)new Exception());
                }
            } else {
                String newName = tn.startName.replace("//", "/traceId:" + traceId + "/");
                Thread.currentThread().setName(newName);
            }
        }
    }

    public static void convertHttpToRpcServer() {
        SetThreadName tn = thSetName.get();
        if (tn != null) {
            String newName = Thread.currentThread().getName().replace("http-request-pool", PREFIX_SERVER_THREAD_NAME);
            Thread.currentThread().setName(newName);
        }
    }

    public static void convertDubboToRpcServer() {
        SetThreadName tn = thSetName.get();
        if (tn != null) {
            String newName = Thread.currentThread().getName().replace("DubboServerHandler", PREFIX_SERVER_THREAD_NAME);
            Thread.currentThread().setName(newName);
        }
    }
}

