/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.thread;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.util.SafeLogUtils;
import kd.bos.util.StringUtils;

public class ThreadLocalUtils {
    private static final String excludeThreadLocals = "exclude.threadlocals";
    private static HashSet<String> excludes = new HashSet();
    private static Method removeOfThreadLocalMap;
    private static Method setOfThreadLocalMap;
    private static Map<String, Field> fieldMap;

    public static void clearCurrentThreadLocals() {
        ThreadLocalUtils.clearThreadLocals(Thread.currentThread());
    }

    public static void clearThreadLocals(Thread t) {
        for (int i = 0; i < 2; ++i) {
            ThreadLocalUtils.doClearThreadLocals(t, false);
        }
    }

    public static void clearThreadLocalsOnlyRemove(Thread t) {
        for (int i = 0; i < 2; ++i) {
            ThreadLocalUtils.doClearThreadLocals(t, true);
        }
    }

    private static void doClearThreadLocals(Thread t, boolean onlyRemove) {
        Object threadLocals = ThreadLocalUtils.getFieldValue("threadLocals", t);
        Object[] tables = (Object[])ThreadLocalUtils.getFieldValue("table", threadLocals);
        if (null == tables) {
            return;
        }
        Method method = ThreadLocalUtils.getRemoveMethod(threadLocals);
        HashSet<Object> tablesSet = new HashSet<Object>(2);
        for (Object entry2 : tables) {
            tablesSet.add(entry2);
        }
        for (Object e : tablesSet) {
            Object threadLocal;
            Object value = ThreadLocalUtils.getFieldValue("value", e);
            if (null == value || !ThreadLocalUtils.shouldClose(value)) continue;
            try {
                if (!onlyRemove) {
                    ThreadLocalUtils.close(value);
                }
            }
            catch (Exception entry2) {
                // empty catch block
            }
            if ((threadLocal = ThreadLocalUtils.getFieldValue("referent", e)) == null) continue;
            try {
                method.invoke(threadLocals, threadLocal);
            }
            catch (Exception e2) {
                SafeLogUtils.error(ThreadLocalUtils.class, e2.getMessage(), e2);
            }
        }
    }

    private static boolean shouldClose(Object value) {
        return !excludes.contains(value.getClass().getName());
    }

    private static void close(Object value) throws Exception {
        if (value instanceof AutoCloseable) {
            ((AutoCloseable)value).close();
        }
    }

    private static Method getRemoveMethod(Object obj) {
        if (removeOfThreadLocalMap == null) {
            for (Method method : obj.getClass().getDeclaredMethods()) {
                if (!method.getName().equals("remove")) continue;
                removeOfThreadLocalMap = method;
                method.setAccessible(true);
                return removeOfThreadLocalMap;
            }
        }
        return removeOfThreadLocalMap;
    }

    private static Method getSetMethod(Object obj) {
        if (setOfThreadLocalMap == null) {
            for (Method method : obj.getClass().getDeclaredMethods()) {
                if (!method.getName().equals("set")) continue;
                setOfThreadLocalMap = method;
                method.setAccessible(true);
                return setOfThreadLocalMap;
            }
        }
        return setOfThreadLocalMap;
    }

    private static Object getFieldValue(String filedName, Object obj) {
        if (null == obj) {
            return null;
        }
        String filedKey = obj.getClass().getName() + filedName;
        Field field = null;
        if (fieldMap.containsKey(filedKey)) {
            field = fieldMap.get(filedKey);
        } else {
            for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(filedName);
                    break;
                }
                catch (Exception e) {
                    SafeLogUtils.none(ThreadLocalUtils.class, e.getMessage(), e);
                    continue;
                }
            }
            if (field == null) {
                return null;
            }
            fieldMap.put(filedKey, field);
        }
        field.setAccessible(true);
        try {
            return field.get(obj);
        }
        catch (Exception e) {
            throw new IllegalStateException("get filed exception :" + e);
        }
    }

    private static void setFiledValue(String filedName, Object obj, Object value) {
        if (null == obj) {
            return;
        }
        String filedKey = obj.getClass().getName() + filedName;
        Field field = null;
        if (fieldMap.containsKey(filedKey)) {
            field = fieldMap.get(filedKey);
        } else {
            for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(filedName);
                    break;
                }
                catch (Exception e) {
                    SafeLogUtils.none(ThreadLocalUtils.class, e.getMessage(), e);
                    continue;
                }
            }
            fieldMap.put(filedKey, field);
        }
        if (field == null) {
            return;
        }
        field.setAccessible(true);
        try {
            field.set(obj, value);
        }
        catch (Exception e) {
            SafeLogUtils.error(ThreadLocalUtils.class, "set filed exception :" + e, e);
        }
    }

    public static Object getThreadLocalMap(Thread t) {
        return ThreadLocalUtils.getFieldValue("threadLocals", t);
    }

    public static void setThreadLocalMap(Thread t, Object o) {
        ThreadLocalUtils.setFiledValue("threadLocals", t, o);
    }

    public static Set<Object> getThreadLocalMapEntrys(Thread t) {
        Object o = ThreadLocalUtils.getThreadLocalMap(t);
        Object[] tables = (Object[])ThreadLocalUtils.getFieldValue("table", o);
        HashSet<Object> tablesSet = new HashSet<Object>(2);
        for (Object entry : tables) {
            tablesSet.add(entry);
        }
        return tablesSet;
    }

    public static void setThreadLocalMapValues(Thread t, Set<Object> toSet, Set<Object> exclude) {
        Method method = ThreadLocalUtils.getSetMethod(ThreadLocalUtils.getFieldValue("threadLocals", t));
        HashSet<Object> tablesSet = new HashSet<Object>(2);
        for (Object entry : toSet) {
            if (exclude.contains(entry)) continue;
            tablesSet.add(entry);
        }
        Object tthreadlocalMap = ThreadLocalUtils.getThreadLocalMap(t);
        for (Object e : tablesSet) {
            ConcurrentHashMap value = ThreadLocalUtils.getFieldValue("value", e);
            if (value == null) continue;
            if (value instanceof ConcurrentHashMap) {
                value = new ConcurrentHashMap(value);
            }
            Object threadLocal = ThreadLocalUtils.getFieldValue("referent", e);
            try {
                method.invoke(tthreadlocalMap, threadLocal, value);
            }
            catch (Exception e2) {
                SafeLogUtils.error(ThreadLocalUtils.class, e2.getMessage(), e2);
            }
        }
    }

    public static Object getThreadLocalValue(Thread t, ThreadLocal<?> threadlocal) {
        Object threadLocals = ThreadLocalUtils.getFieldValue("threadLocals", t);
        Object[] tables = (Object[])ThreadLocalUtils.getFieldValue("table", threadLocals);
        if (null == tables) {
            return null;
        }
        for (Object o : tables) {
            Object threadLocalFiled = ThreadLocalUtils.getFieldValue("referent", o);
            if (threadLocalFiled != threadlocal) continue;
            Object value = ThreadLocalUtils.getFieldValue("value", o);
            return value;
        }
        return null;
    }

    public static void main(String[] args) {
        ThreadLocal<Integer> localInteger = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return -1;
            }
        };
        ThreadLocal<AutoCloseable> localClose = new ThreadLocal<AutoCloseable>(){

            @Override
            protected AutoCloseable initialValue() {
                return new AutoCloseable(){

                    @Override
                    public void close() throws Exception {
                    }

                    public String toString() {
                        return "toString initial";
                    }
                };
            }
        };
        localInteger.set(10);
        localClose.set(new AutoCloseable(){

            @Override
            public void close() throws Exception {
            }

            public String toString() {
                return "toString 1";
            }
        });
        long t1 = System.nanoTime();
        ThreadLocalUtils.clearCurrentThreadLocals();
        long t2 = System.nanoTime();
        t1 = System.nanoTime();
        ThreadLocalUtils.clearCurrentThreadLocals();
        t2 = System.nanoTime();
        t1 = System.nanoTime();
        localInteger.get();
        localClose.get();
        ThreadLocalUtils.clearCurrentThreadLocals();
        t2 = System.nanoTime();
    }

    static {
        excludes.add("org.eclipse.jetty.server.HttpConnection");
        String excludeThreadLocalsStr = System.getProperty(excludeThreadLocals);
        if (StringUtils.isNotEmpty(excludeThreadLocalsStr)) {
            String[] tempThreadLocals;
            for (String excludeThreadLocal : tempThreadLocals = excludeThreadLocalsStr.split(",")) {
                excludes.add(excludeThreadLocal);
            }
        }
        removeOfThreadLocalMap = null;
        setOfThreadLocalMap = null;
        fieldMap = new ConcurrentHashMap<String, Field>();
    }
}

