/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.useragent.util;

import java.io.Serializable;
import kd.bos.useragent.util.Browser;
import kd.bos.useragent.util.OperatingSystem;
import kd.bos.useragent.util.Version;

public class UserAgentUtils
implements Serializable {
    private static final long serialVersionUID = 7025462762784240212L;
    private OperatingSystem operatingSystem;
    private Browser browser;
    private int id;
    private String userAgentString;

    @Deprecated
    public UserAgentUtils() {
        this(OperatingSystem.UNKNOWN, Browser.UNKNOWN);
    }

    public UserAgentUtils(OperatingSystem operatingSystem, Browser browser) {
        this.operatingSystem = operatingSystem;
        this.browser = browser;
        this.id = (operatingSystem.getId() << 16) + browser.getId();
    }

    public UserAgentUtils(String userAgentString) {
        String userAgentLowercaseString = userAgentString == null ? null : userAgentString.toLowerCase();
        Browser browser = Browser.parseUserAgentLowercaseString(userAgentLowercaseString);
        OperatingSystem operatingSystem = OperatingSystem.UNKNOWN;
        if (browser != Browser.BOT) {
            operatingSystem = OperatingSystem.parseUserAgentLowercaseString(userAgentLowercaseString);
        }
        this.operatingSystem = operatingSystem;
        this.browser = browser;
        this.id = (operatingSystem.getId() << 16) + browser.getId();
        this.userAgentString = userAgentString;
    }

    public static UserAgentUtils parseUserAgentString(String userAgentString) {
        return new UserAgentUtils(userAgentString);
    }

    public Version getBrowserVersion() {
        return this.browser.getVersion(this.userAgentString);
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.operatingSystem.toString() + "-" + this.browser.toString();
    }

    public static UserAgentUtils valueOf(int id) {
        OperatingSystem operatingSystem = OperatingSystem.valueOf((short)(id >> 16));
        Browser browser = Browser.valueOf((short)(id & 0xFFFF));
        return new UserAgentUtils(operatingSystem, browser);
    }

    public static UserAgentUtils valueOf(String name) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        String[] elements = name.split("-");
        if (elements.length == 2) {
            OperatingSystem operatingSystem = OperatingSystem.valueOf(elements[0]);
            Browser browser = Browser.valueOf(elements[1]);
            return new UserAgentUtils(operatingSystem, browser);
        }
        throw new IllegalArgumentException("Invalid string for userAgent " + name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.browser == null ? 0 : this.browser.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.operatingSystem == null ? 0 : this.operatingSystem.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAgentUtils other = (UserAgentUtils)obj;
        if (this.browser == null ? other.browser != null : !this.browser.equals((Object)other.browser)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return !(this.operatingSystem == null ? other.operatingSystem != null : !this.operatingSystem.equals((Object)other.operatingSystem));
    }
}

