/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;
import kd.sdk.annotation.SdkPublic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkPublic
public class ConfigurationUtil {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationUtil.class);
    private static ConcurrentHashMap<String, List<ConfigurationChangeListener>> map = new ConcurrentHashMap();

    private static String _get(String key, boolean includeEnv) {
        String v = SystemProperties.get(key);
        if (v == null && includeEnv) {
            v = System.getenv(key);
        }
        return v;
    }

    public static String getString(String key, String defaultValue, boolean includeEnv) {
        String v = ConfigurationUtil._get(key, includeEnv);
        return v == null ? defaultValue : v;
    }

    public static String getString(String key, String defaultValue) {
        return ConfigurationUtil.getString(key, defaultValue, true);
    }

    public static String getString(String key) {
        return ConfigurationUtil.getString(key, null);
    }

    public static Integer getInteger(String key, Integer defaultValue, boolean includeEnv) {
        String v = ConfigurationUtil._get(key, includeEnv);
        return v == null ? defaultValue : Integer.valueOf(v);
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        return ConfigurationUtil.getInteger(key, defaultValue, true);
    }

    public static Integer getInteger(String key) {
        return ConfigurationUtil.getInteger(key, null);
    }

    public static Long getLong(String key, Long defaultValue, boolean includeEnv) {
        String v = ConfigurationUtil._get(key, includeEnv);
        return v == null ? defaultValue : Long.valueOf(v);
    }

    public static Long getLong(String key, Long defaultValue) {
        return ConfigurationUtil.getLong(key, defaultValue, true);
    }

    public static Long getLong(String key) {
        return ConfigurationUtil.getLong(key, null);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue, boolean includeEnv) {
        String v = ConfigurationUtil._get(key, includeEnv);
        return v == null ? defaultValue : Boolean.valueOf(v);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return ConfigurationUtil.getBoolean(key, defaultValue, true);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue, String tenantId) {
        Boolean returnValue = defaultValue;
        String keyValue = System.getProperty(tenantId + "_" + key);
        if (StringUtils.isEmpty(keyValue)) {
            keyValue = System.getProperty(key);
        }
        if (StringUtils.isNotEmpty(keyValue) && "true".equalsIgnoreCase(keyValue.trim())) {
            returnValue = Boolean.TRUE;
        }
        if (StringUtils.isNotEmpty(keyValue) && "false".equalsIgnoreCase(keyValue.trim())) {
            returnValue = Boolean.FALSE;
        }
        return returnValue;
    }

    public static Boolean getBoolean(String key) {
        return ConfigurationUtil.getBoolean(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void observeChange(String key, ConfigurationChangeListener listener) {
        List list;
        List list2 = list = map.computeIfAbsent(key, k -> new ArrayList(2));
        synchronized (list2) {
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireChanged(String key, Object newValue) {
        List<ConfigurationChangeListener> list = map.get(key);
        if (list != null) {
            ArrayList<ConfigurationChangeListener> copy;
            List<ConfigurationChangeListener> list2 = list;
            synchronized (list2) {
                copy = new ArrayList<ConfigurationChangeListener>(list);
            }
            for (ConfigurationChangeListener l : copy) {
                try {
                    l.onChange(key, newValue);
                }
                catch (Exception t) {
                    log.error("ConfigurationChangeListener onChange error", (Throwable)t);
                }
            }
        }
    }

    public static void observeInteger(String property, int defaultValue, ConfigurationChangeHandler<Integer> cb) {
        InnerFunction func = () -> {
            String s = System.getProperty(property, String.valueOf(defaultValue));
            if (s.matches("\\d+")) {
                cb.onChanged(Integer.parseInt(s));
            } else {
                cb.onChanged(defaultValue);
            }
        };
        ConfigurationUtil.observeChange(property, func);
    }

    public static void observeLong(String property, long defaultValue, ConfigurationChangeHandler<Long> cb) {
        InnerFunction func = () -> {
            String s = System.getProperty(property, String.valueOf(defaultValue));
            if (s.matches("\\d+")) {
                cb.onChanged(Long.parseLong(s));
            } else {
                cb.onChanged(defaultValue);
            }
        };
        ConfigurationUtil.observeChange(property, func);
    }

    public static void observeBoolean(String property, boolean defaultValue, ConfigurationChangeHandler<Boolean> cb) {
        InnerFunction func = () -> {
            boolean v = Boolean.valueOf(System.getProperty(property, String.valueOf(defaultValue)));
            cb.onChanged(v);
        };
        ConfigurationUtil.observeChange(property, func);
    }

    public static void observeString(String property, String defaultValue, ConfigurationChangeHandler<String> cb) {
        InnerFunction func = () -> {
            String v = System.getProperty(property, String.valueOf(defaultValue));
            cb.onChanged(v);
        };
        ConfigurationUtil.observeChange(property, func);
    }

    private static void observeChange(String property, final InnerFunction func) {
        ConfigurationUtil.observeChange(property, new ConfigurationChangeListener(){

            @Override
            public void onChange(Object key, Object newValue) {
                func.call();
            }
        });
        func.call();
    }

    @FunctionalInterface
    public static interface ConfigurationChangeHandler<V> {
        public void onChanged(V var1);
    }

    @FunctionalInterface
    private static interface InnerFunction {
        public void call();
    }
}

