/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.stream.Stream;
import kd.bos.util.SystemProperties;

public class EnvUtils {
    private static int PID = -1;
    private static int ContainerTag = -1;
    private static final String OPERATING_SYSTEM_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final String LINUX_HOSTNAME_COMMAND = "hostname";

    public static boolean isWindows() {
        return OPERATING_SYSTEM_NAME.startsWith("windows");
    }

    public static boolean isLinux() {
        return OPERATING_SYSTEM_NAME.startsWith("liunx");
    }

    public static boolean isMac() {
        return OPERATING_SYSTEM_NAME.startsWith("mac") || OPERATING_SYSTEM_NAME.startsWith("darwin");
    }

    public static boolean isRunningInsideContainer() {
        if (ContainerTag < 0) {
            try (Stream<String> stream = Files.lines(Paths.get("/proc/1/cgroup", new String[0]));){
                boolean isContainer = stream.anyMatch(line -> line.contains(SystemProperties.getWithEnv("containerIdentify", "/kubepods")));
                System.setProperty("isRunningInsideContainer", String.valueOf(isContainer));
                ContainerTag = isContainer ? 1 : 2;
            }
            catch (Exception e) {
                ContainerTag = 0;
            }
        }
        return ContainerTag == 1;
    }

    public static int getPid() {
        if (PID < 0) {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                String name = runtime.getName();
                PID = Integer.parseInt(name.substring(0, name.indexOf(64)));
            }
            catch (Exception e) {
                PID = 0;
            }
        }
        return PID;
    }

    public static String getHostNameForContainer() {
        String hostName = "";
        if (EnvUtils.isRunningInsideContainer()) {
            try {
                Process ps = Runtime.getRuntime().exec(LINUX_HOSTNAME_COMMAND);
                try (InputStream inputStream = ps.getInputStream();
                     InputStreamReader isr = new InputStreamReader(inputStream);
                     LineNumberReader br = new LineNumberReader(isr);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        hostName = line;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hostName;
    }
}

