/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public class MaskUtil {
    public static String maskJsonString(String jsonString, int reserveLength) {
        String maskedValue;
        if (jsonString.startsWith("{") && jsonString.endsWith("}")) {
            try {
                maskedValue = MaskUtil.maskJsonObject(JSON.parseObject((String)jsonString), reserveLength).toJSONString();
            }
            catch (Exception e) {
                maskedValue = "**";
            }
        } else if (jsonString.startsWith("[") && jsonString.endsWith("]")) {
            try {
                maskedValue = MaskUtil.maskJsonArray(JSON.parseArray((String)jsonString), reserveLength).toJSONString();
            }
            catch (Exception e) {
                maskedValue = "**";
            }
        } else {
            maskedValue = MaskUtil.maskString(jsonString, reserveLength);
        }
        return maskedValue;
    }

    public static JSONObject maskJsonObject(JSONObject jsonObject, int reserveLength) {
        JSONObject masked = new JSONObject();
        for (String key : jsonObject.keySet()) {
            Object obj = jsonObject.get((Object)key);
            Object maskedObj = obj instanceof JSONObject ? MaskUtil.maskJsonObject((JSONObject)obj, reserveLength) : (obj instanceof JSONArray ? MaskUtil.maskJsonArray((JSONArray)obj, reserveLength) : (obj == null ? null : MaskUtil.maskString(obj.toString(), reserveLength)));
            masked.put(MaskUtil.maskString(key, reserveLength), maskedObj);
        }
        return masked;
    }

    public static JSONArray maskJsonArray(JSONArray jsonArray, int reserveLength) {
        JSONArray masked = new JSONArray();
        jsonArray.forEach(obj -> {
            Object maskedObj = obj instanceof JSONObject ? MaskUtil.maskJsonObject((JSONObject)obj, reserveLength) : (obj instanceof JSONArray ? MaskUtil.maskJsonArray((JSONArray)obj, reserveLength) : (obj == null ? null : MaskUtil.maskString(obj.toString(), reserveLength)));
            masked.add(maskedObj);
        });
        return masked;
    }

    public static String maskString(String text, int reserveLength) {
        String masked = text != null && text.length() >= reserveLength ? text.substring(0, reserveLength) + "**" : (text == null ? "**" : text + "**");
        return masked;
    }
}

