/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorHttpClients {
    private static int default_connectionTimeout = 3000;
    private static int default_readTimeout = 5000;
    private static String SCHEME_HTTPS = "https";
    private static final Logger logger = LoggerFactory.getLogger(MonitorHttpClients.class);

    private static HttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(connectionTimeout).setSocketTimeout(readTimeout).build()).build();
        return client;
    }

    public static HttpClient wrapperHttpClient(HttpClient client) {
        if (client == null) {
            client = MonitorHttpClients.createHttpClient(default_connectionTimeout, default_readTimeout);
        }
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme(SCHEME_HTTPS, 443, (SchemeSocketFactory)ssf));
            ThreadSafeClientConnManager mgr = new ThreadSafeClientConnManager(registry);
            return new DefaultHttpClient((ClientConnectionManager)mgr, client.getParams());
        }
        catch (Exception ex) {
            StringBuilder sb = new StringBuilder(Resources.getString("\u5305\u88c5\u65e0\u8bc1\u4e66\u6821\u9a8c\u5ba2\u6237\u7aef\u5931\u8d25:", "EyeCommon_0", "bos-eye", new Object[0]));
            sb.append(ex.getMessage());
            return null;
        }
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return MonitorHttpClients.post(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String data = "";
        HttpClient client = MonitorHttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = MonitorHttpClients.wrapperHttpClient(client)) == null) {
            return data;
        }
        try {
            HttpResponse response;
            if (header != null && header.size() != 0) {
                header.forEach((key, value) -> post.setHeader(key, value));
            }
            if (body != null && body.size() != 0) {
                ArrayList params = new ArrayList(body.size());
                body.forEach((key, value) -> params.add(new BasicNameValuePair(key, value.toString())));
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
                post.setEntity((HttpEntity)entity);
            }
            if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = MonitorHttpClients.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            logger.error("post error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String postjson(String url, Map<String, String> header, String json) throws IOException {
        return MonitorHttpClients.postjson(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    public static String postjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        String data = "";
        HttpClient client = MonitorHttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = MonitorHttpClients.wrapperHttpClient(client)) == null) {
            return data;
        }
        try {
            if (header != null && header.size() != 0) {
                header.forEach((key, value) -> post.setHeader(key, value));
            }
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
            se.setContentType("text/json;");
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = MonitorHttpClients.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String postAppJson(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return MonitorHttpClients.postAppJson(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String postAppJson(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "application/json;";
        String data = "";
        HttpClient client = MonitorHttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme()) && (client = MonitorHttpClients.wrapperHttpClient(client)) == null) {
            return data;
        }
        try {
            if (header != null && header.size() != 0) {
                header.forEach((key, value) -> post.setHeader(key, value));
            }
            String jsEntity = "{}";
            if (body != null) {
                jsEntity = JSONUtils.toString(body);
            }
            StringEntity se = new StringEntity(jsEntity, ContentType.APPLICATION_JSON);
            se.setContentType("application/json;");
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = MonitorHttpClients.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            logger.error("post error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String get(String url) throws Exception {
        return MonitorHttpClients.get(url, default_connectionTimeout, default_readTimeout);
    }

    public static String get(String url, int connectionTimeout, int readTimeout) throws IOException, URISyntaxException {
        BufferedReader in = null;
        String content = null;
        try {
            String line;
            HttpClient client = MonitorHttpClients.createHttpClient(connectionTimeout, readTimeout);
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            HttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuilder sb = new StringBuilder();
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line).append(NL);
            }
            content = sb.toString();
        }
        catch (IOException | URISyntaxException e) {
            logger.error("url: [" + url + "] get error: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return content;
    }

    public static String get(String url, Map<String, String> headers, int connectionTimeout, int readTimeout) throws IOException, URISyntaxException {
        String content;
        String strBody = "";
        try (BufferedReader in = null;){
            String line;
            String destUrl = "";
            destUrl = StringUtils.isEmpty(strBody) ? url : url + "?" + strBody;
            HttpClient client = MonitorHttpClients.createHttpClient(connectionTimeout, readTimeout);
            HttpGet request = new HttpGet();
            if (headers != null && headers.size() != 0) {
                headers.forEach((key, value) -> request.setHeader(key, value));
            }
            request.setURI(new URI(destUrl));
            HttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            content = sb.toString();
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHTMLContent(InputStream in) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            String string = sb.toString();
            return string;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    public static String putjson(String url, Map<String, String> header, String json) throws Exception {
        return MonitorHttpClients.putjson(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String putjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        HttpClient client = MonitorHttpClients.createHttpClient(connectionTimeout, readTimeout);
        HttpPut httpput = new HttpPut(url);
        String data = "";
        try {
            HttpResponse response;
            if (header != null && header.size() != 0) {
                header.forEach((key, value) -> httpput.setHeader(key, value));
            }
            if (!StringUtils.isEmpty(json)) {
                StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
                se.setContentType("text/json;");
                httpput.setEntity((HttpEntity)se);
            }
            if ((response = client.execute((HttpUriRequest)httpput)).getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = MonitorHttpClients.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            String string = data;
            return string;
        }
        finally {
            httpput.releaseConnection();
        }
        return data;
    }

    public static String postFormData(String url, Map<String, String> headers, List<FormDataEntity> formDatas) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFormData(String url, Map<String, String> headers, List<FormDataEntity> formDatas, int connectionTimeout, int readTimeout) {
        HttpClient httpclient = MonitorHttpClients.createHttpClient(connectionTimeout, readTimeout);
        try {
            HttpPost httppost = new HttpPost(url);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> string : headers.entrySet()) {
                    httppost.setHeader(string.getKey(), string.getValue());
                }
            }
            try {
                MultipartEntity reqEntity = new MultipartEntity();
                if (formDatas != null && !formDatas.isEmpty()) {
                    for (FormDataEntity e : formDatas) {
                        if (e.getValueInputStream() != null) {
                            reqEntity.addPart(e.getKey(), (ContentBody)new InputStreamBody(e.getValueInputStream(), e.getFileName()));
                            continue;
                        }
                        reqEntity.addPart(e.getKey(), (ContentBody)new StringBody(e.getValueString()));
                    }
                }
                httppost.setEntity((HttpEntity)reqEntity);
                HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httppost);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    HttpEntity resEntity = httpResponse.getEntity();
                    String result = EntityUtils.toString((HttpEntity)resEntity);
                    EntityUtils.consume((HttpEntity)resEntity);
                    String string = result;
                    return string;
                }
            }
            catch (IOException e) {
                String string = null;
                return string;
            }
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }

    public static class FormDataEntity {
        private String key;
        private String valueString;
        private InputStream valueInputStream;
        private String fileName;

        public FormDataEntity(String key, String value) {
            this.key = key;
            this.valueString = value;
        }

        public FormDataEntity(String key, InputStream value, String fileName) {
            this.key = key;
            this.valueInputStream = value;
            this.fileName = fileName;
        }

        public String getKey() {
            return this.key;
        }

        public String getValueString() {
            return this.valueString;
        }

        public InputStream getValueInputStream() {
            return this.valueInputStream;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

