/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kd.bos.bundle.Resources;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static Map<String, String> constants = new HashMap<String, String>();
    private static boolean initConstant = false;
    private static Logger LOG = LoggerFactory.getLogger(PropertiesUtil.class);
    private static final String PROJECT_NAME = "appid";

    public static String getConstant(String key) {
        try {
            if (!initConstant) {
                initConstant = true;
                Properties properties = new Properties();
                try (InputStream inputStream = PropertiesUtil.class.getResourceAsStream("/resources/constant.properties");){
                    properties.load(inputStream);
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String name = (String)enumeration.nextElement();
                        String value = properties.getProperty(name);
                        constants.put(name, value);
                    }
                }
            }
            return constants.get(key);
        }
        catch (Exception var5) {
            throw new RuntimeException("can't found constant.properties");
        }
    }

    public static String getAppIdName(String appId) {
        try {
            return StringUtils.isEmpty(appId) ? "" : Resources.get(PROJECT_NAME, appId.toUpperCase(Locale.ENGLISH), "AppIdName", new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("PropertiesUtil getAppIdName exception", (Throwable)e);
            return "";
        }
    }
}

