/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeLogUtils {
    private static Map<String, Logger> logs = new ConcurrentHashMap<String, Logger>(2);

    private static Logger getLog(Class<?> cla) {
        return logs.computeIfAbsent(cla.getName(), k -> LoggerFactory.getLogger((String)k));
    }

    public static void error(Class<?> cla, String message, Throwable t) {
        try {
            SafeLogUtils.getLog(cla).error(message, t);
        }
        catch (Error | Exception e) {
            SafeLogUtils.parseLogError(e);
        }
    }

    public static void info(Class<?> cla, String message, Throwable t) {
        try {
            SafeLogUtils.getLog(cla).info(message, t);
        }
        catch (Error | Exception e) {
            SafeLogUtils.parseLogError(e);
        }
    }

    public static void info(Class<?> cla, String message) {
        try {
            SafeLogUtils.getLog(cla).info(message);
        }
        catch (Error | Exception e) {
            SafeLogUtils.parseLogError(e);
        }
    }

    public static void debug(Class<?> cla, String message, Throwable t) {
        try {
            SafeLogUtils.getLog(cla).debug(message, t);
        }
        catch (Error | Exception e) {
            SafeLogUtils.parseLogError(e);
        }
    }

    public static void none(Class<?> cla, String message, Throwable t) {
    }

    private static void parseLogError(Throwable e) {
    }
}

