/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.util.DisCardUtil;
import kd.bos.util.StringUtils;
import org.apache.commons.io.FilenameUtils;

public class SecurityUtils {
    public static boolean containsSqlInjection(String obj) {
        boolean isInjected = false;
        if (StringUtils.isNotEmpty(obj)) {
            Pattern pattern = Pattern.compile("\\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|;|\\+|'|%)");
            Matcher matcher = pattern.matcher(obj);
            isInjected = matcher.find();
        }
        return isInjected;
    }

    public static String htmlEncode(String htmlStr) {
        String[] arr = "&@<@>@\"@'@/".split("@");
        String[] code = "&amp;@&lt;@&gt;@&quot;@&#x27;@&#x2F;".split("@");
        String returnValue = htmlStr;
        try {
            if (StringUtils.isNotEmpty(htmlStr)) {
                for (int i = 0; i < arr.length; ++i) {
                    returnValue = htmlStr.replaceAll(arr[i], code[i]);
                }
            }
        }
        catch (NullPointerException e) {
            DisCardUtil.discard();
        }
        return returnValue;
    }

    public static String htmlEncode0(String htmlStr) {
        String[] arr = "&@<@>@\"@'@/".split("@");
        String[] code = "&amp;@&lt;@&gt;@&quot;@&#x27;@&#x2F;".split("@");
        String returnValue = htmlStr;
        try {
            if (StringUtils.isNotEmpty(htmlStr)) {
                for (int i = 0; i < arr.length; ++i) {
                    returnValue = returnValue.replaceAll(arr[i], code[i]);
                }
            }
        }
        catch (NullPointerException e) {
            DisCardUtil.discard();
        }
        return returnValue;
    }

    public static String normalize(String fileName) {
        String returnString = fileName;
        if (fileName != null) {
            returnString = fileName.replace("../", "#");
            returnString = returnString.replace("..\\", "#");
        }
        returnString = FilenameUtils.normalize((String)returnString);
        return returnString;
    }
}

