/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.zip.io.inputstream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import kd.bos.zip.io.inputstream.SplitInputStream;
import org.apache.commons.io.FilenameUtils;

public class ZipStandardSplitInputStream
extends SplitInputStream {
    private int lastSplitZipFileNumber;

    public ZipStandardSplitInputStream(File zipFile, boolean isSplitZipArchive, int lastSplitZipFileNumber) throws FileNotFoundException {
        super(zipFile, isSplitZipArchive, lastSplitZipFileNumber);
        this.lastSplitZipFileNumber = lastSplitZipFileNumber;
    }

    @Override
    protected File getNextSplitFile(int zipFileIndex) throws IOException {
        if (zipFileIndex == this.lastSplitZipFileNumber) {
            return this.zipFile;
        }
        String currZipFileNameWithPath = this.zipFile.getCanonicalPath();
        String extensionSubString = ".z0";
        if (zipFileIndex >= 9) {
            extensionSubString = ".z";
        }
        return new File(FilenameUtils.normalize((String)(currZipFileNameWithPath.substring(0, currZipFileNameWithPath.lastIndexOf(".")) + extensionSubString + (zipFileIndex + 1))));
    }
}

