/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.zip.tasks;

import java.io.File;
import java.io.IOException;
import java.util.List;
import kd.bos.zip.exception.ZipException;
import kd.bos.zip.headers.HeaderWriter;
import kd.bos.zip.model.Zip4jConfig;
import kd.bos.zip.model.ZipModel;
import kd.bos.zip.model.ZipParameters;
import kd.bos.zip.progress.ProgressMonitor;
import kd.bos.zip.tasks.AbstractAddFileToZipTask;
import kd.bos.zip.tasks.AbstractZipTaskParameters;
import kd.bos.zip.tasks.AsyncZipTask;

public class AddFilesToZipTask
extends AbstractAddFileToZipTask<AddFilesToZipTaskParameters> {
    public AddFilesToZipTask(ZipModel zipModel, char[] password, HeaderWriter headerWriter, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, password, headerWriter, asyncTaskParameters);
    }

    @Override
    protected void executeTask(AddFilesToZipTaskParameters taskParameters, ProgressMonitor progressMonitor) throws IOException {
        this.verifyZipParameters(taskParameters.zipParameters);
        this.addFilesToZip(taskParameters.filesToAdd, progressMonitor, taskParameters.zipParameters, taskParameters.zip4jConfig);
    }

    @Override
    protected long calculateTotalWork(AddFilesToZipTaskParameters taskParameters) throws ZipException {
        return this.calculateWorkForFiles(taskParameters.filesToAdd, taskParameters.zipParameters);
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return super.getTask();
    }

    public static class AddFilesToZipTaskParameters
    extends AbstractZipTaskParameters {
        private final List<File> filesToAdd;
        private final ZipParameters zipParameters;

        public AddFilesToZipTaskParameters(List<File> filesToAdd, ZipParameters zipParameters, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.filesToAdd = filesToAdd;
            this.zipParameters = zipParameters;
        }
    }
}

