/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import kd.bos.eye.util.ExchangeVueUtils;

public class EyeResourceHandler
implements HttpHandler {
    private static final String HEADER = "Content-Type";
    private final String path;
    private String context;

    public EyeResourceHandler(String path, String context) {
        this.path = path;
        this.context = context;
    }

    /*
     * Loose catch block
     */
    private byte[] readBytes(InputStream str) throws IOException {
        try {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int thisLine;
                while ((thisLine = str.read()) != -1) {
                    bos.write(thisLine);
                }
                bos.flush();
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (str != null) {
                str.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange pExchange) throws IOException {
        OutputStream os = null;
        try {
            InputStream in;
            URI uri = pExchange.getRequestURI();
            String reqPath = uri.getPath();
            int pos = reqPath.indexOf(this.context);
            reqPath = reqPath.substring(pos + this.context.length());
            if (!reqPath.startsWith("/")) {
                reqPath = uri.getPath() + "/";
                ExchangeVueUtils.redirect(pExchange, reqPath);
            }
            if ("/".equals(reqPath)) {
                reqPath = "/index.html";
            }
            if ((in = EyeResourceHandler.class.getResourceAsStream(this.path + reqPath)) == null) {
                pExchange.sendResponseHeaders(404, 0L);
                pExchange.close();
                return;
            }
            if (reqPath.endsWith(".js")) {
                pExchange.getResponseHeaders().set(HEADER, "text/javascript; charset=UTF-8");
            } else if (reqPath.endsWith(".css")) {
                pExchange.getResponseHeaders().set(HEADER, "text/css; charset=UTF-8");
            } else if (reqPath.endsWith(".html")) {
                pExchange.getResponseHeaders().set(HEADER, "text/html; charset=UTF-8");
            }
            byte[] response = this.readBytes(in);
            if (reqPath.endsWith("/index.html")) {
                String text = new String(response, StandardCharsets.UTF_8);
                response = text.getBytes(StandardCharsets.UTF_8);
            }
            pExchange.sendResponseHeaders(202, response.length);
            os = pExchange.getResponseBody();
            os.write(response);
        }
        catch (Exception e) {
            byte[] bytes = e.getMessage().getBytes(StandardCharsets.UTF_8);
            pExchange.getResponseHeaders().set(HEADER, "application/json; charset=UTF-8");
            pExchange.sendResponseHeaders(202, bytes.length);
            pExchange.getResponseBody().write(bytes);
        }
        finally {
            if (os != null) {
                os.close();
            }
            pExchange.close();
        }
    }
}

