/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.alarm;

import com.alibaba.fastjson.JSON;
import com.google.common.io.CharStreams;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.eye.api.alarm.db.AlarmRecordDbHelper;
import kd.bos.eye.api.alarm.record.enums.RecordState;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class AlarmRecordHandler
extends AbstractHttpHandler {
    private static final Log LOGGER = LogFactory.getLog(AlarmRecordHandler.class);
    private static final String PLACEHOLDER = "/record/";
    private final String CLASS_SIMPLENAME = this.getClass().getSimpleName();
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        response.setCode(-1);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        response.setData(map);
        URI uri = exchange.getRequestURI();
        String reqPath = uri.getPath();
        int pos = reqPath.indexOf(PLACEHOLDER);
        String endPoint = reqPath.substring(pos + PLACEHOLDER.length());
        try {
            Map<String, String> params;
            if (endPoint.equals("list")) {
                RecordState recordState;
                Map<String, Object> paramMap = this.getBodyToMap(exchange);
                String state = (String)paramMap.get("state");
                if (kd.bos.util.StringUtils.isNotEmpty((String)state) && (recordState = RecordState.getValueOf(state)) == null) {
                    response.setMsg(LangRes.get((String)(this.CLASS_SIMPLENAME + "_0"), (String)"Illegal request, intercepted", (Object[])new Object[0]));
                    this.writeJson(JSONUtils.toString(response), exchange);
                    return;
                }
                String alarmConfigName = (String)paramMap.get("alarmConfigName");
                String alarmTime = (String)paramMap.get("alarmTime");
                int page = (Integer)paramMap.get("page");
                int size = (Integer)paramMap.get("size");
                List<Map<String, String>> recordMapList = AlarmRecordDbHelper.findRecordPage(alarmConfigName, state, alarmTime, page, size);
                map.put("recordList", recordMapList);
                int recordTotal = AlarmRecordDbHelper.getRecordTotal(alarmConfigName, state, alarmTime);
                map.put("total", recordTotal);
                response.setCode(0);
            } else if (endPoint.equals("delete") && (params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery())).containsKey("id")) {
                this.deleteAlarmRecord(params.get("id"));
                OPLOGGER.opLog(exchange, OpType.DELETE, LangRes.get((String)"AlarmRecordHandler_1", (String)"\u544a\u8b66\u8bb0\u5f55", (Object[])new Object[0]), LangRes.get((String)"AlarmRecordHandler_3", (String)"\u5220\u9664\u544a\u8b66\u8bb0\u5f55\u6570\u636e,\u4e3b\u952eid:", (Object[])new Object[0]) + params.get("id"));
                response.setCode(0);
            }
        }
        catch (Exception ex) {
            LOGGER.error("alarmRecordException:{}", (Object)ex.getMessage());
            response.setCode(-1);
            response.setMsg("alarmRecord exception, message: " + ex.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private Map<String, Object> getBodyToMap(HttpExchange exchange) throws IOException {
        InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), StandardCharsets.UTF_8);
        String query = CharStreams.toString((Readable)isr);
        String str = StringUtils.trimToNull((String)query);
        return (Map)JSON.parseObject((String)str, Map.class);
    }

    private int deleteAlarmRecord(String fid) {
        ArrayList<String> deleteList = new ArrayList<String>(1);
        DBRequest dbRequest = new DBRequest();
        String deleteSql = "delete from t_monitor_alarm_record where fid = ?";
        deleteList.add(fid);
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
        return MetadataFactory.getStatement().executeDelete((Request)dbRequest);
    }
}

