/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.alarm.db;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.db.DBType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.government.metadata.db.DBConfig;
import kd.bos.government.metadata.db.DBHelper;

public class AlarmBaseDbHelper {
    protected static String buildInsertSql(String tableName, int filedSize) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into ").append(tableName).append(" values( ");
        for (int i = 0; i < filedSize; ++i) {
            if (i == filedSize - 1) {
                insertSql.append("?)");
                continue;
            }
            insertSql.append("?,");
        }
        return insertSql.toString();
    }

    protected static String buildUpdateSql(String tableName, String[] updateFields, String[] filterFields) {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(tableName).append(" ");
        int updateSize = updateFields.length;
        for (int i = 0; i < updateSize; ++i) {
            if (i == 0) {
                updateSql.append("set ");
            }
            updateSql.append(updateFields[i]).append("= ?");
            if (i == updateSize - 1) continue;
            updateSql.append(",");
        }
        updateSql.append(" where ");
        int fileterSize = filterFields.length;
        for (int i = 0; i < fileterSize; ++i) {
            updateSql.append(filterFields[i]).append(" = ?");
            if (i == fileterSize - 1) continue;
            updateSql.append(" and ");
        }
        return updateSql.toString();
    }

    protected static String buildTotalSql(String tableName, String[] filterFields) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select count(1) total from ").append(tableName);
        if (filterFields != null && filterFields.length > 0) {
            int fileterSize = filterFields.length;
            querySql.append(" where ");
            for (int i = 0; i < fileterSize; ++i) {
                querySql.append(filterFields[i]).append(" = ?");
                if (i == fileterSize - 1) continue;
                querySql.append(" and ");
            }
        }
        return querySql.toString();
    }

    protected static String buildTopQuerySql(String tableName, String[] queryFields, String[] filterFields, int page, int size) {
        int offset = (page - 1) * size;
        StringBuilder querySql = new StringBuilder();
        querySql.append("select top ").append(size).append(',').append(offset).append(" ");
        int querySize = queryFields.length;
        for (int i = 0; i < querySize; ++i) {
            querySql.append(queryFields[i]);
            if (i == querySize - 1) continue;
            querySql.append(",");
        }
        querySql.append(" from ").append(tableName);
        if (filterFields != null && filterFields.length > 0) {
            int fileterSize = filterFields.length;
            querySql.append(" where ");
            for (int i = 0; i < fileterSize; ++i) {
                querySql.append(filterFields[i]).append(" = ?");
                if (i == fileterSize - 1) continue;
                querySql.append(" and ");
            }
        }
        return querySql.toString();
    }

    protected static String buildQuerySql(String tableName, String[] queryFields, String[] filterFields) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select ");
        int querySize = queryFields.length;
        for (int i = 0; i < querySize; ++i) {
            querySql.append(queryFields[i]);
            if (i == querySize - 1) continue;
            querySql.append(",");
        }
        querySql.append(" from ").append(tableName);
        if (filterFields != null && filterFields.length > 0) {
            int fileterSize = filterFields.length;
            querySql.append(" where ");
            for (int i = 0; i < fileterSize; ++i) {
                querySql.append(filterFields[i]).append(" = ?");
                if (i == fileterSize - 1) continue;
                querySql.append(" and ");
            }
        }
        return querySql.toString();
    }

    protected static String buildDeleteSql(String tableName, String[] filterFields) {
        StringBuilder deleteSql = new StringBuilder();
        deleteSql.append("delete from ").append(tableName).append(" where ");
        int fileterSize = filterFields.length;
        for (int i = 0; i < fileterSize; ++i) {
            deleteSql.append(filterFields[i]).append(" = ?");
            if (i == fileterSize - 1) continue;
            deleteSql.append(" and ");
        }
        return deleteSql.toString();
    }

    protected static boolean needContainEscape() {
        DBConfig dbConfig = null;
        try {
            dbConfig = DBHelper.getDbConfig();
        }
        catch (Exception e) {
            return false;
        }
        Integer dbType = dbConfig.getDbType();
        return dbType.intValue() == DBType.DM.getValue() || dbType.intValue() == DBType.Oracle.getValue();
    }

    protected static LocalDateTime parseStrToLDT(String str) {
        DateTimeFormatter sysDateFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (str.length() >= 19) {
            return LocalDateTime.parse(str.substring(0, 19), sysDateFmt);
        }
        throw new KDException(BosErrorCode.bOS, new Object[]{"illegal str!"});
    }
}

