/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.alarm.db;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.alarm.config.AlarmExtInfo;
import kd.bos.eye.api.alarm.config.AlarmInfo;
import kd.bos.eye.api.alarm.config.action.ActionInfo;
import kd.bos.eye.api.alarm.config.metric.MetricInfo;
import kd.bos.eye.api.alarm.db.AlarmBaseDbHelper;
import kd.bos.eye.api.alarm.db.DBFields;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.eye.config.custom.ConfigEntity;
import kd.bos.eye.config.custom.ConfigModule;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.login.utils.DateUtils;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class AlarmConfigDbHelper
extends AlarmBaseDbHelper {
    public static final String ONE_STR = "1";

    public static boolean saveKeyValue(String key, String value) {
        List<ConfigEntity> configEntityList = ConfigDbHelper.getConfigsByKey(key, ConfigModule.ALARM_CONFIG.getNumber());
        if (CollectionUtils.isNotEmpty(configEntityList)) {
            ConfigEntity configEntity = configEntityList.get(0);
            configEntity.setValue(value);
            return ConfigDbHelper.updateConfigToDb(configEntity);
        }
        return false;
    }

    public static boolean saveAlarm(AlarmInfo alarmInfo) throws IOException {
        DBRequest dbRequest = new DBRequest();
        long id = alarmInfo.getId();
        LocalDateTime updateTime = alarmInfo.getUpdateTime();
        if (updateTime == null) {
            updateTime = LocalDateTime.now();
        }
        if (AlarmConfigDbHelper.getAlarmInfoById(id) == null) {
            ArrayList insertList = new ArrayList(1);
            String insertSql = AlarmConfigDbHelper.buildInsertSql("T_MONITOR_ALARM_CONFIG", DBFields.AlarmConfig.getAllFields().length);
            Collections.addAll(insertList, alarmInfo.getId(), alarmInfo.getName(), alarmInfo.getDes(), alarmInfo.isActionEnabled() ? ONE_STR : "0", alarmInfo.isAndMetric() ? ONE_STR : "0", JSONUtils.toString(alarmInfo.getMetricInfoList()), JSONUtils.toString(alarmInfo.getActionInfoList()), alarmInfo.getUpdateUser(), updateTime, JSONUtils.toString((Object)alarmInfo.getAlarmExtInfo()));
            dbRequest.setInsertRequest(new DBRequest.InsertRequest(insertSql, insertList));
            return MetadataFactory.getStatement().executeInsert((Request)dbRequest) > 0;
        }
        ArrayList updateList = new ArrayList(10);
        String updateSql = AlarmConfigDbHelper.buildUpdateSql("T_MONITOR_ALARM_CONFIG", DBFields.AlarmConfig.getUpdateFields("fid"), new String[]{"fid"});
        Collections.addAll(updateList, alarmInfo.getName(), alarmInfo.getDes(), alarmInfo.isActionEnabled() ? ONE_STR : "0", alarmInfo.isAndMetric() ? ONE_STR : "0", JSONUtils.toString(alarmInfo.getMetricInfoList()), JSONUtils.toString(alarmInfo.getActionInfoList()), alarmInfo.getUpdateUser(), updateTime, JSONUtils.toString((Object)alarmInfo.getAlarmExtInfo()), alarmInfo.getId());
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
        return MetadataFactory.getStatement().executeUpdate((Request)dbRequest) > 0;
    }

    public static boolean delAlarmById(long id) {
        DBRequest dbRequest = new DBRequest();
        ArrayList deleteList = new ArrayList(1);
        Collections.addAll(deleteList, id);
        String deleteSql = AlarmConfigDbHelper.buildDeleteSql("T_MONITOR_ALARM_CONFIG", new String[]{"fid"});
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
        return MetadataFactory.getStatement().executeDelete((Request)dbRequest) > 0;
    }

    public static AlarmInfo getAlarmInfoById(long id) throws IOException {
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, id);
        DBRequest dbRequest = new DBRequest();
        String querySql = AlarmConfigDbHelper.buildQuerySql("T_MONITOR_ALARM_CONFIG", DBFields.AlarmConfig.getAllFields(), new String[]{"fid"});
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        if (!results.isEmpty()) {
            return AlarmConfigDbHelper.resultToAlarmInfo((Result)results.get(0));
        }
        return null;
    }

    public static AlarmInfo getAlarmInfoByName(String name) throws IOException {
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, name);
        DBRequest dbRequest = new DBRequest();
        String querySql = AlarmConfigDbHelper.buildQuerySql("T_MONITOR_ALARM_CONFIG", DBFields.AlarmConfig.getAllFields(), new String[]{"fname"});
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        if (!results.isEmpty()) {
            return AlarmConfigDbHelper.resultToAlarmInfo((Result)results.get(0));
        }
        return null;
    }

    public static List<AlarmInfo> getAlarmInfos() throws IOException {
        DBRequest dbRequest = new DBRequest();
        String querySql = AlarmConfigDbHelper.buildQuerySql("T_MONITOR_ALARM_CONFIG", DBFields.AlarmConfig.getAllFields(), new String[0]);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, new ArrayList(0)));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        if (!results.isEmpty()) {
            ArrayList<AlarmInfo> alarmInfos = new ArrayList<AlarmInfo>(8);
            for (Result result : results) {
                alarmInfos.add(AlarmConfigDbHelper.resultToAlarmInfo(result));
            }
            return alarmInfos;
        }
        return null;
    }

    private static AlarmInfo resultToAlarmInfo(Result result) throws IOException {
        AlarmInfo alarmInfo = new AlarmInfo();
        alarmInfo.setId(Long.parseLong(result.getString("fid")));
        alarmInfo.setName(result.getString("fname"));
        alarmInfo.setDes(result.getString("fdes"));
        alarmInfo.setAndMetric(ONE_STR.equals(result.getString("fisaddmetrics")));
        alarmInfo.setUpdateUser(result.getString("fupdateuser"));
        alarmInfo.setUpdateTime(AlarmConfigDbHelper.parseStrToLDT(result.getString("fupdatetime")));
        alarmInfo.setActionEnabled(ONE_STR.equals(result.getString("fenableaction")));
        alarmInfo.addActionInfoList((List)JSONUtils.cast((String)result.getString("factions"), ArrayList.class, (Class[])new Class[]{ActionInfo.class}));
        alarmInfo.addMetricInfoList((List)JSONUtils.cast((String)result.getString("fmetrics"), ArrayList.class, (Class[])new Class[]{MetricInfo.class}));
        String extJson = result.getString("fextjson");
        if (StringUtils.isNotEmpty((String)extJson)) {
            alarmInfo.setAlarmExtInfo((AlarmExtInfo)JSONUtils.cast((String)extJson, AlarmExtInfo.class));
        }
        return alarmInfo;
    }

    public static List<Map<String, String>> findConfigPage(String alarmConfigName, String updateTime, int page, int size) {
        ArrayList<Map<String, String>> resultList = null;
        ArrayList<String> queryList = new ArrayList<String>(10);
        StringBuilder sb = new StringBuilder();
        String selectSql = AlarmConfigDbHelper.buildTopQuerySql("T_MONITOR_ALARM_CONFIG", DBFields.AlarmConfig.getAllFields(), null, page, size);
        sb.append(selectSql);
        if (StringUtils.isNotEmpty((String)alarmConfigName)) {
            sb.append(" where fname like ? ");
            if (AlarmConfigDbHelper.needContainEscape()) {
                sb.append(" escape '\\' ");
            }
            alarmConfigName = alarmConfigName.replace("%", "\\%");
            queryList.add("%" + alarmConfigName + "%");
        }
        if (StringUtils.isNotEmpty((String)updateTime)) {
            if (queryList.size() == 0) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append("fupdatetime >=? ");
            queryList.add(updateTime);
        }
        sb.append(" order by fupdatetime desc");
        try {
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sb.toString(), queryList));
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            resultList = new ArrayList<Map<String, String>>(retunList.size());
            for (Result row : retunList) {
                HashMap<String, String> tempMap = new HashMap<String, String>();
                tempMap.put("id", row.getString("fid"));
                tempMap.put("alarmConfigName", row.getString("fname"));
                tempMap.put("des", row.getString("fdes"));
                tempMap.put("extJson", row.getString("fextjson"));
                tempMap.put("enableAction", row.getString("fenableaction"));
                tempMap.put("updateUser", row.getString("fupdateuser"));
                tempMap.put("updateTime", DateUtils.formatDate((Date)DateUtils.parseDateTime((String)row.getString("fupdatetime"), (String)"yyyy-MM-dd HH:mm:ss"), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
                tempMap.put("isAddMetrics", row.getString("fisaddmetrics"));
                tempMap.put("metrics", row.getString("fmetrics"));
                tempMap.put("actions", row.getString("factions"));
                resultList.add(tempMap);
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
        return resultList;
    }

    public static int getConfigTotal(String alarmConfigName, String updateTime) {
        ArrayList<String> queryList = new ArrayList<String>(2);
        String[] filterFields = null;
        if (StringUtils.isNotEmpty((String)alarmConfigName)) {
            filterFields = new String[]{"fname"};
            queryList.add(alarmConfigName);
        }
        StringBuilder sb = new StringBuilder();
        String selectSql = AlarmConfigDbHelper.buildTotalSql("T_MONITOR_ALARM_CONFIG", filterFields);
        sb.append(selectSql);
        if (StringUtils.isNotEmpty((String)alarmConfigName)) {
            if (queryList.size() == 0) {
                sb.append(" where ");
            } else {
                sb.append(" or ");
            }
            sb.append("fname like ? ");
            if (AlarmConfigDbHelper.needContainEscape()) {
                sb.append(" escape '\\' ");
            }
            alarmConfigName = alarmConfigName.replace("%", "\\%");
            queryList.add("%" + alarmConfigName + "%");
        }
        if (StringUtils.isNotEmpty((String)updateTime)) {
            if (queryList.size() == 0) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append("fupdatetime >=? ");
            queryList.add(updateTime);
        }
        try {
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sb.toString(), queryList));
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            return Integer.parseInt(((Result)retunList.get(0)).getString("total"));
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
    }
}

