/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.alarm.record.task;

import java.io.IOException;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import kd.bos.dlock.DLock;
import kd.bos.eye.api.alarm.db.AlarmRecordDbHelper;
import kd.bos.eye.api.alarm.record.RecordInfo;
import kd.bos.eye.api.alarm.record.enums.RecordState;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.util.CollectionUtils;

public class AlarmRecordTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(AlarmRecordTask.class);

    @Override
    public void run() {
        DLock dLock = DLock.create((String)"AlarmRecordTask-check");
        try {
            if (!dLock.tryLock()) {
                return;
            }
            this.checkAlarmRecords();
        }
        catch (Exception e) {
            LOGGER.error("AlarmRecordWork-check error:", (Throwable)e);
        }
        finally {
            dLock.unlock();
        }
    }

    private void checkAlarmRecords() throws IOException {
        List<RecordInfo> recordInfoList = AlarmRecordDbHelper.findRecordInfosByState(RecordState.ALARM.getDesc());
        if (CollectionUtils.isEmpty(recordInfoList)) {
            return;
        }
        HashMap<String, Long> ipStartTimeMap = new HashMap<String, Long>(8);
        List allNodeInfo = ServiceInfoFactory.get().getServiceList();
        for (ServiceInfo tempServiceInfo : allNodeInfo) {
            ipStartTimeMap.put(tempServiceInfo.getInstanceId(), tempServiceInfo.getStartTimestamp());
        }
        for (RecordInfo recordInfo : recordInfoList) {
            String ip = recordInfo.getIp();
            if (ipStartTimeMap.containsKey(ip)) {
                long statTime = recordInfo.getStartTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                if ((Long)ipStartTimeMap.get(ip) <= statTime) continue;
                recordInfo.setState(RecordState.RESTART);
                AlarmRecordDbHelper.saveRecord(recordInfo);
                continue;
            }
            recordInfo.setState(RecordState.RESTART);
            AlarmRecordDbHelper.saveRecord(recordInfo);
        }
    }
}

