/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.apicall;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.eye.api.apicall.APICallHandler;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.util.ApiResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class APICallDetailHandler
extends APICallHandler {
    private static final Log log = LogFactory.getLog(APICallDetailHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            List filteredList;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Map<String, String> params = this.getParams(exchange, false);
            String start = params.get("start");
            String end = params.get("end");
            String apiName = params.get("apiName");
            List list = storage.apiCallDetail(dateFormat.parse(start), end != null ? dateFormat.parse(end) : new Date(), apiName);
            String durationMicros = params.get("durationMicros");
            if (durationMicros != null) {
                long along = Long.parseLong(durationMicros) * 1000L;
                filteredList = list.stream().filter(map -> {
                    Object durationMicrosObj = map.get("durationMicros");
                    return durationMicrosObj instanceof Number && ((Number)durationMicrosObj).longValue() > along;
                }).collect(Collectors.toList());
            } else {
                filteredList = list;
            }
            response.setCode(0);
            response.setData(filteredList);
        }
        catch (Exception e) {
            log.error("API\u76d1\u63a7\u8be6\u7ec6\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            response.setCode(-1);
            response.setMsg(LangRes.get((String)"APICallHandler_1", (String)("API monitoring query exception, exception information: " + e.getMessage()), (Object[])new Object[0]));
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }
}

