/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.appha.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.appha.entity.TimeRangeAndAppNameParam;
import kd.bos.eye.api.appha.helper.Utils;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.mservice.monitor.query.HealthQuery;
import kd.bos.mservice.monitor.query.TotalAppHealthData;
import kd.bos.util.JSONUtils;

public class AppHealthQueryHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(4);
        TimeRangeAndAppNameParam param = ExchangeVueUtils.parseJsonFromPost(exchange, TimeRangeAndAppNameParam.class);
        try {
            Date[] dateTimeRange = Utils.getQueryDateTimeRange(param);
            Map healthDataMap = HealthQuery.queryHistoryApplicationHealth((Date)dateTimeRange[0], (Date)dateTimeRange[1]);
            HashMap<String, List<String>> data = new HashMap<String, List<String>>();
            data.put("appNames", this.getAllAppNameList(healthDataMap));
            data.put("appHealthData", this.getAppHealthData(healthDataMap));
            response.put("code", 0);
            response.put("data", data);
            response.put("msg", "success");
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("data", null);
            response.put("msg", e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<String> getAllAppNameList(Map<String, TotalAppHealthData> healthDataMap) {
        ArrayList<String> appNameList = new ArrayList<String>(healthDataMap.size());
        for (Map.Entry<String, TotalAppHealthData> entry : healthDataMap.entrySet()) {
            appNameList.add(entry.getKey());
        }
        return appNameList;
    }

    private List<TotalAppHealthData> getAppHealthData(Map<String, TotalAppHealthData> healthDataMap) {
        ArrayList<TotalAppHealthData> totalAppHealthDataList = new ArrayList<TotalAppHealthData>(healthDataMap.size());
        for (Map.Entry<String, TotalAppHealthData> entry : healthDataMap.entrySet()) {
            totalAppHealthDataList.add(entry.getValue());
        }
        return totalAppHealthDataList;
    }
}

