/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.appinfo;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.service.EyeServerService;
import kd.bos.eye.util.ApiResponse;
import kd.bos.instance.Instance;
import kd.bos.util.JSONUtils;

public class AppInfoApiHandler
extends AbstractHttpHandler {
    public static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            List<EyeNodeInfo> serverNodes = this.getSortedNodeInfos();
            String clusterName = Instance.getClusterName();
            response.setCode(0);
            response.setMsg("success");
            HashMap<String, Object> data = new HashMap<String, Object>(8);
            data.put("appNameList", serverNodes);
            data.put("clusterName", clusterName);
            response.setData(data);
        }
        catch (Exception e) {
            response.setCode(1);
            response.setMsg(e.getMessage());
            response.setData(null);
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private List<EyeNodeInfo> getSortedNodeInfos() {
        ArrayList<EyeNodeInfo> list = EyeServerService.getAllEyeNodes();
        try {
            Comparator<EyeNodeInfo> byAppName = Comparator.comparing(EyeNodeInfo::getAppName);
            Comparator<EyeNodeInfo> byStartTime = Comparator.comparing(EyeNodeInfo::getStartTimestamp);
            list.sort(byAppName.thenComparing(byStartTime));
        }
        catch (Exception er) {
            throw new RuntimeException("Get monitor node error", er);
        }
        return list;
    }
}

