/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.armor.vo.DegradeRuleVo;
import kd.bos.eye.api.armor.vo.FlowRuleVo;
import kd.bos.eye.api.armor.vo.RuleVo;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.instance.Instance;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;

public class ArmorDbHelper {
    private static final String SIGNATURE = "signature";

    public static List<RuleVo> getRule(Class cla) {
        if (DBHelper.dbIsConfigured()) {
            return ArmorDbHelper.getFromDB(null, cla);
        }
        return null;
    }

    public static List<RuleVo> getRule(String resource, Class cla) {
        if (DBHelper.dbIsConfigured()) {
            return ArmorDbHelper.getFromDB(resource, cla);
        }
        return null;
    }

    private static List<RuleVo> getFromDB(String resource, Class<RuleVo> cla) {
        String ruleType;
        if (FlowRuleVo.class.isAssignableFrom(cla)) {
            ruleType = "flow";
        } else if (DegradeRuleVo.class.isAssignableFrom(cla)) {
            ruleType = "degrade";
        } else {
            throw new IllegalArgumentException("Unsupported Class type");
        }
        return ArmorDbHelper.getFromDB(resource, ruleType, cla);
    }

    private static List<RuleVo> getFromDB(String resource, String ruleType, Class<RuleVo> cla) {
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fvalue from t_monitor_armor_rule where fclustername = ? and ftype = ?";
        StringBuilder queryStringBuilder = new StringBuilder(querySql);
        ArrayList<String> queryList = new ArrayList<String>(2);
        Collections.addAll(queryList, Instance.getClusterName(), ruleType);
        if (StringUtils.isNotEmpty((String)resource)) {
            queryStringBuilder.append(" AND fkey like ?");
            queryList.add(resource.replaceAll("/", "-") + "%");
        }
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(queryStringBuilder.toString(), queryList));
        ArrayList<RuleVo> resultList = null;
        try {
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            resultList = new ArrayList<RuleVo>(retunList.size());
            for (Result row : retunList) {
                String jsonValue = row.getString("fvalue");
                RuleVo rule = (RuleVo)JSONUtils.cast((String)jsonValue, cla, (boolean)true);
                resultList.add(rule);
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
        return resultList;
    }

    public static List<Map<String, Object>> getApiMetadataFromDB() {
        int apiCount = Integer.getInteger("armor.api.limit.count", 1000);
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> queryList = new ArrayList<String>(1);
        String querySql = "select distinct top " + apiCount + ",0 a.fapiname from t_monitor_api_metadata a  where a.fclustername = ? ";
        queryList.add(Instance.getClusterName());
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(retunList.size());
        for (Result row : retunList) {
            HashMap<String, String> map = new HashMap<String, String>(4);
            String apiName = row.getString("fapiname");
            map.put(SIGNATURE, ArmorDbHelper.getFullApiName(apiName));
            resultList.add(map);
        }
        return resultList;
    }

    private static String getFullApiName(String apiName) {
        String contextPath = SystemProperties.getWithEnv((String)"JETTY_CONTEXT", (String)"/ierp");
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        if (apiName.startsWith("/") && !apiName.startsWith(contextPath)) {
            apiName = contextPath + apiName;
        }
        return apiName;
    }
}

