/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.service.EyeServerService;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public final class Grocery {
    public static final String FLOW_RULE_TYPE = "flow";
    public static final String DEGRADE_RULE_TYPE = "degrade";
    public static final String GET_RULES_PATH = "getRules";
    public static final String SET_RULES_PATH = "setRules";
    public static final String APP_NAME = Instance.getAppName();
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HTTP_HEADER_CONTENT_TYPE_URLENCODED = ContentType.create((String)"application/x-www-form-urlencoded").toString();
    private static final int RULE_PUSH_INTERVAL = Integer.getInteger("monitor.push.rule.interval", 5000);
    public static final String GET_DATA_FROM_MC = "/kapi/app/mc/DataSaveGetService";
    public static final String SET_DATA_TO_MC = "/kapi/app/mc/DataSaveSetService";
    private static final String RULES_WAREHOUSE_NAME = "armor-rules-warehouse-" + Instance.getClusterName().toLowerCase();
    private static final Log logger = LogFactory.getLog(Grocery.class);
    private static AtomicBoolean isInit = new AtomicBoolean(true);
    private static final int HTTP_CONNECTION_TIMEOUT = Integer.getInteger("monitor.http.connect.timeout", 5000);
    private static final int HTTP_REQUEST_TIMEOUT = Integer.getInteger("monitor.http.request.timeout", 5000);
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String HTTP_PRE = "http://";

    public static ArrayList<EyeNodeInfo> getAllNodeInfo() {
        return EyeServerService.getAllEyeNodes();
    }

    private static HttpClient createHttpClient(int requestTimeout, int connectTimeout) {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(connectTimeout).setConnectionRequestTimeout(requestTimeout).setConnectTimeout(connectTimeout).build()).build();
        return client;
    }

    public static String httpPost(String ip, int port, Map<String, String> params, String api) throws IOException {
        return Grocery.httpPost(ip, port, params, api, HTTP_REQUEST_TIMEOUT, HTTP_CONNECTION_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String ip, int port, Map<String, String> params, String api, int requestTimeout, int connectTimeout) throws IOException {
        HttpClient httpClient = null;
        try {
            httpClient = Grocery.createHttpClient(requestTimeout, connectTimeout);
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(HTTP_PRE);
            urlBuilder.append(ip).append(':').append(port).append('/').append(api);
            if (params == null) {
                params = Collections.emptyMap();
            }
            HttpPost httpPost = new HttpPost(urlBuilder.toString());
            if (params != null && params.size() > 0) {
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, Consts.UTF_8));
                httpPost.setHeader(HTTP_HEADER_CONTENT_TYPE, HTTP_HEADER_CONTENT_TYPE_URLENCODED);
            }
            HttpResponse execute = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = execute.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName(DEFAULT_CHARSET));
            return string;
        }
        finally {
            if (httpClient instanceof CloseableHttpClient) {
                ((CloseableHttpClient)httpClient).close();
            }
        }
    }

    public static String httpPost(String ip, int port, String json, String api) throws IOException {
        return Grocery.httpPost(ip, port, json, api, HTTP_REQUEST_TIMEOUT, HTTP_CONNECTION_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String ip, int port, String json, String api, int requestTimeout, int connectTimeout) throws IOException {
        HttpClient httpClient = Grocery.createHttpClient(requestTimeout, connectTimeout);
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(HTTP_PRE);
            urlBuilder.append(ip).append(':').append(port).append('/').append(api);
            HttpPost httpPost = new HttpPost(urlBuilder.toString());
            if (StringUtils.isNotEmpty((String)json)) {
                httpPost.setEntity((HttpEntity)new StringEntity(json, Consts.UTF_8));
                httpPost.setHeader(HTTP_HEADER_CONTENT_TYPE, "application/json");
                httpPost.setHeader(EyeProxyHandler.PROXY_HEADER_KEY, EyeProxyHandler.PROXY_HEADER_VALUE);
            }
            HttpResponse execute = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = execute.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName(DEFAULT_CHARSET));
            return string;
        }
        finally {
            if (httpClient instanceof CloseableHttpClient) {
                ((CloseableHttpClient)httpClient).close();
            }
        }
    }

    public static Set<String> getAppNames() {
        ArrayList<EyeNodeInfo> allNodeInfo = Grocery.getAllNodeInfo();
        HashSet<String> appNames = new HashSet<String>(8);
        for (EyeNodeInfo nodeInfo : allNodeInfo) {
            appNames.add(nodeInfo.getAppName());
        }
        return appNames;
    }
}

