/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor.config;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kd.bos.armor.transport.datasource.Converter;
import kd.bos.eye.api.armor.config.dataSource.ArmorDataSource;
import kd.bos.eye.api.armor.config.dataSource.db.DbDataSource;
import kd.bos.eye.api.armor.config.dataSource.zk.ZookeeperDataSource;
import kd.bos.instance.Instance;

public class ArmorDataSourceFactory {
    private static final Map<String, ArmorDataSource> armorDataSourcePool = new ConcurrentHashMap<String, ArmorDataSource>(2);

    public static ArmorDataSource getArmorDataSource(String path) {
        return ArmorDataSourceFactory.getArmorDataSource(null, path, null, null);
    }

    public static ArmorDataSource getArmorDataSource(String path, Converter<String, Object> parser, Function<String, List<String>> loadDBDataCall) {
        return ArmorDataSourceFactory.getArmorDataSource(null, path, parser, loadDBDataCall);
    }

    public static ArmorDataSource getArmorDataSource(String region, String path, Converter<String, Object> parser, Function<String, List<String>> loadDBDataCall) {
        String configType = System.getProperty("eye.config.type", "db");
        if (!path.contains(Instance.getClusterName())) {
            path = Instance.getClusterName() + path;
        }
        String finalPath = path;
        return armorDataSourcePool.computeIfAbsent(finalPath, k -> {
            if ("zookeeper".equals(configType)) {
                return new ZookeeperDataSource(region, finalPath, parser, loadDBDataCall);
            }
            return new DbDataSource(region, finalPath, parser, loadDBDataCall);
        });
    }
}

