/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor.config.dataSource.db;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kd.bos.armor.core.concurrent.NamedThreadFactory;
import kd.bos.armor.transport.datasource.Converter;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.armor.config.dataSource.ArmorBroadcastService;
import kd.bos.eye.api.armor.config.dataSource.ArmorDataSource;
import kd.bos.eye.api.armor.config.dataSource.ArmorWritableSourceManager;
import kd.bos.eye.api.armor.vo.RuleVo;
import kd.bos.eye.config.broadcast.EyeConfigBroadcastHelper;
import kd.bos.govern.GovernConfigs;
import kd.bos.government.Constant;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DbDataSource<T>
extends ArmorDataSource<T> {
    private static final Log log = LogFactory.getLog(DbDataSource.class);
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("monitor-db-armor-update", true));
    private final String region;
    private final String path;
    private final Function<String, List<String>> loadDBDataCall;

    public DbDataSource(String region, String path, Converter<String, T> parser, Function<String, List<String>> loadDBDataCall) {
        super(parser);
        this.region = region;
        this.path = path;
        this.loadDBDataCall = loadDBDataCall;
        this.init();
    }

    private void init() {
        this.initScheduledTask();
    }

    private void initScheduledTask() {
        scheduler.scheduleWithFixedDelay(() -> {
            if (!GovernConfigs.getBreakerEnable() || Boolean.getBoolean("eye.config.db.schedule.disable")) {
                return;
            }
            if (!DBHelper.dbIsConfigured()) {
                return;
            }
            try {
                Object newValue = this.loadConfig();
                this.getProperty().updateValue(newValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 60L, Constant.MONITOR_CONFIG_SCHEDULE_EXECUTE_SECONDS, TimeUnit.SECONDS);
    }

    private void loadInitialConfigFromDB() {
        try {
            if (DBHelper.dbIsConfigured()) {
                Object newValue = this.loadConfig();
                this.getProperty().updateValue(newValue);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String readSource() throws Exception {
        List<String> list = this.loadDBDataCall.apply("initDataFromDB");
        if (list != null && list.size() > 0) {
            return list.toString();
        }
        return null;
    }

    @Override
    public void updateRule(RuleVo ruleVo) throws Exception {
        try {
            if (ruleVo.getStatIntervalMs() != 1000 && (ruleVo.getStatIntervalMs() % 10 != 0 || ruleVo.getStatIntervalMs() <= 0 || ruleVo.getStatIntervalMs() > 1000000000)) {
                throw new KDException(BosErrorCode.paramError, new Object[]{"The statInterval must be a number equal to 1 or a multiple of 10 less than 1000000 "});
            }
            if (ArmorWritableSourceManager.write(ruleVo)) {
                Object newValue = this.loadConfig();
                this.getProperty().updateValue(newValue);
                EyeConfigBroadcastHelper.broadCast(ArmorBroadcastService.class.getName(), "receiveConfigChange", this.path, null, null);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateRuleLs(List<RuleVo> ruleVo) throws Exception {
        try {
            if (ruleVo == null || ruleVo.size() == 0) {
                return;
            }
            if (ArmorWritableSourceManager.writeBatch(ruleVo)) {
                Object newValue = this.loadConfig();
                this.getProperty().updateValue(newValue);
                EyeConfigBroadcastHelper.broadCast(ArmorBroadcastService.class.getName(), "receiveConfigChange", this.path, null, null);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            throw e;
        }
    }

    public void close() {
    }
}

