/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor.dataSource;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.slots.block.degrade.DegradeRuleManager;
import kd.bos.armor.core.slots.block.flow.FlowRuleManager;
import kd.bos.armor.transport.datasource.WritableDataSource;
import kd.bos.eye.api.armor.dataSource.ZookeeperDataSource;
import kd.bos.eye.api.armor.vo.DegradeRuleVo;
import kd.bos.eye.api.armor.vo.FlowRuleVo;
import kd.bos.eye.api.armor.vo.RuleVo;
import kd.bos.eye.api.log.KDException;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Statement;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.instance.Instance;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;

@Deprecated
public class ZookeeperWritableSource
implements WritableDataSource<RuleVo> {
    private static void saveZK(int updateType, String id, String childrenPath, String value) {
        try {
            String hosts = System.getProperty("configUrl");
            CuratorFramework client = ZKFactory.getZKClient((String)hosts);
            switch (updateType) {
                case 0: {
                    ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)client.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(childrenPath, value.getBytes(StandardCharsets.UTF_8));
                    break;
                }
                case 2: {
                    client.setData().forPath(childrenPath, value.getBytes(StandardCharsets.UTF_8));
                    break;
                }
                case 3: {
                    client.delete().forPath(childrenPath);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (Exception e) {
            ZookeeperWritableSource.rollBack(id);
            RecordLog.error((String)"[ZookeeperWritableSource] Error when saveZK", (Throwable)e);
            throw new KDException("bos-exception", e);
        }
    }

    private static boolean persistentSave(int updateType, String id, String type, String resource, String value) {
        DBRequest dbRequest = new DBRequest();
        Statement statement = MetadataFactory.getStatement();
        switch (updateType) {
            case 0: {
                String insertSql = "insert into t_monitor_armor_rule values(?,?,?,?,?,?)";
                ArrayList insertList = new ArrayList(6);
                Collections.addAll(insertList, id, Instance.getClusterName(), type, resource, value, LocalDateTime.now());
                dbRequest.setInsertRequest(new DBRequest.InsertRequest(insertSql, insertList));
                return statement.executeInsert((Request)dbRequest) > 0;
            }
            case 2: {
                String updateSql = "update t_monitor_armor_rule set fvalue= ?,fupdatetime = ? where fid = ?";
                ArrayList updateList = new ArrayList(3);
                Collections.addAll(updateList, value, LocalDateTime.now(), id);
                dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
                return statement.executeUpdate((Request)dbRequest) > 0;
            }
            case 3: {
                String deleteSql = "delete from t_monitor_armor_rule where fid = ?";
                ArrayList deleteList = new ArrayList(1);
                Collections.addAll(deleteList, id);
                dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
                return statement.executeDelete((Request)dbRequest) > 0;
            }
        }
        return false;
    }

    private static boolean rollBack(String id) {
        DBRequest dbRequest = new DBRequest();
        String deleteSql = "delete from t_monitor_armor_rule where fid = ?";
        ArrayList deleteList = new ArrayList(1);
        Collections.addAll(deleteList, id);
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
        return MetadataFactory.getStatement().executeDelete((Request)dbRequest) > 0;
    }

    public void write(RuleVo ruleVo) {
        String resource = null;
        String jsonValue = JSON.toJSONString((Object)ruleVo);
        String type = null;
        String id = ruleVo.getId();
        int updateType = ruleVo.getRequestType();
        if (ruleVo instanceof FlowRuleVo) {
            resource = ((FlowRuleVo)ruleVo).getResource().replaceAll("/", "-");
            type = "flow";
            ZookeeperDataSource flowRuleDataSource = (ZookeeperDataSource)FlowRuleManager.getDataSource();
            String childrenPath = flowRuleDataSource.getPath() + '/' + id;
            if (ZookeeperWritableSource.persistentSave(updateType, id, type, resource, jsonValue)) {
                ZookeeperWritableSource.saveZK(updateType, id, childrenPath, jsonValue);
            }
        } else {
            resource = ((DegradeRuleVo)ruleVo).getResource().replaceAll("/", "-");
            type = "degrade";
            ZookeeperDataSource flowRuleDataSource = (ZookeeperDataSource)DegradeRuleManager.getDataSource();
            String childrenPath = flowRuleDataSource.getPath() + '/' + id;
            if (ZookeeperWritableSource.persistentSave(updateType, id, type, resource, jsonValue)) {
                ZookeeperWritableSource.saveZK(updateType, id, childrenPath, jsonValue);
            }
        }
    }

    public void close() {
    }
}

