/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.config;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.config.manager.DbConfigManager;
import kd.bos.eye.api.config.vo.DbConfigInfo;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.Encrypt;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.MonitorLoginUtils;
import kd.bos.government.metadata.db.DBConfig;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.TableInit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class DbConfigHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String CACHE_KEY = "DBConfig";
    private static final String monitorDbPwdShow = "monitor.db.pwd.show";
    private static final Log log = LogFactory.getLog(DbConfigHandler.class);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            DbConfigInfo dbInfo = ExchangeVueUtils.parseJsonFromPost(exchange, DbConfigInfo.class);
            if (!EyeAuther.checkPermission(exchange, "dbConfig", dbInfo.getRequestType() + "")) {
                throw new KDException("No permission!");
            }
            if (dbInfo.getRequestType() == 2) {
                dbInfo.setPassword(MonitorLoginUtils.getDecryptPassword(CACHE_KEY, dbInfo.getPassword()));
                this.updateDbConfigInfo(dbInfo);
            }
            HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
            DBConfig dbConfig = DBHelper.getDbConfig();
            DbConfigInfo dbConfigInfo = null;
            if (dbConfig != null) {
                dbConfigInfo = new DbConfigInfo();
                dbConfigInfo.setDbName(dbConfig.getDbName());
                dbConfigInfo.setDbType(dbConfig.getDbType());
                dbConfigInfo.setIp(dbConfig.getIp());
                dbConfigInfo.setPort(String.valueOf(dbConfig.getPort()));
                dbConfigInfo.setUserName(dbConfig.getUserName());
                String dbPassword = "******";
                try {
                    if (Boolean.parseBoolean(System.getProperty(monitorDbPwdShow, "false")) && StringUtils.isNotEmpty((String)dbInfo.getEncryptKey())) {
                        String aesEncryptKey = MonitorLoginUtils.getDecryptPassword(CACHE_KEY, dbInfo.getEncryptKey());
                        dbPassword = Encrypt.encryptAes(dbConfig.getPassword(), aesEncryptKey);
                    }
                }
                catch (Exception e) {
                    log.error("\u6570\u636e\u5e93\u79d8\u94a5\u89e3\u5bc6\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
                }
                dbConfigInfo.setPassword(dbPassword);
            }
            returnMap.put("configStatus", System.getProperty("isDBConfigured"));
            returnMap.put("dbConfigInfo", Collections.singleton(dbConfigInfo));
            response.setCode(0);
            response.setData(returnMap);
            this.addOpLog(exchange, dbInfo.getRequestType());
        }
        catch (Exception e) {
            response.setCode(-1);
            response.setMsg(LangRes.get((String)"DbConfigHandler_1", (String)"\u6570\u636e\u5e93\u914d\u7f6e\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f:{0}", (Object[])new Object[]{e.getMessage()}));
            log.error("\u6570\u636e\u5e93\u914d\u7f6e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private void updateDbConfigInfo(DbConfigInfo dbInfo) throws Exception {
        DBConfig dbConfig = new DBConfig(dbInfo.getDbType(), dbInfo.getIp(), Integer.valueOf(dbInfo.getPort()), dbInfo.getDbName(), dbInfo.getUserName(), dbInfo.getPassword());
        try (Connection connection = DBHelper.getDBConnection((DBConfig)dbConfig);){
            TableInit.initMonitorTable((DBConfig)dbConfig);
            dbConfig.setPassword(Encrypters.encode((String)dbConfig.getPassword()));
        }
        catch (Exception e) {
            throw new KDException(e);
        }
        DBConfig oldDbConfig = DBHelper.getDbConfig();
        if (!(oldDbConfig == null || oldDbConfig.getDbType().intValue() == dbConfig.getDbType().intValue() && oldDbConfig.getIp().equals(dbConfig.getIp()) && oldDbConfig.getDbName().equals(dbConfig.getDbName()))) {
            DbConfigManager.updateLocalpropAndDelZK();
        }
        DbConfigManager.saveConfig(dbConfig);
    }

    private void addOpLog(HttpExchange exchange, int requestType) {
        if (requestType == 2) {
            OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"DbConfigHandler_2", (String)"\u5b58\u50a8\u5e93\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"DbConfigHandler_3", (String)"\u4fee\u6539\u5b58\u50a8\u5e93\u914d\u7f6e", (Object[])new Object[0]));
        }
    }
}

