/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.config;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.config.manager.GovernConfigManager;
import kd.bos.eye.api.config.vo.GovConfigInfo;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class GovernConfigHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static Log log = LogFactory.getLog(GovernConfigHandler.class);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
            if (!DBHelper.dbIsConfigured()) {
                response.setCode(0);
                returnMap.put("enable", "false");
                response.setData(returnMap);
                this.writeJson(JSONUtils.toString(response), exchange);
                return;
            }
            GovConfigInfo paramInfo = ExchangeVueUtils.parseJsonFromPost(exchange, GovConfigInfo.class);
            int requestType = paramInfo.getRequestType();
            if (requestType == 2) {
                this.updateGovConfigInfo(paramInfo);
            }
            DBRequest dbRequest = new DBRequest();
            ArrayList queryList = new ArrayList(3);
            StringBuilder querySqlBuilder = new StringBuilder();
            String querySql = null;
            querySql = querySqlBuilder.append("select fgovkey,fgovvalue from t_monitor_govern_config  where fclustername = ?").toString();
            Collections.addAll(queryList, Instance.getClusterName());
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            HashMap<String, String> resultMap = new HashMap<String, String>(retunList.size());
            for (Result row : retunList) {
                String govKey = row.getString("fgovkey");
                String govvalue = row.getString("fgovvalue");
                String mapKey = GovConfigInfo.conversionKey(govKey);
                if (StringUtils.isNotEmpty((String)mapKey)) {
                    resultMap.put(mapKey, govvalue);
                }
                if (!StringUtils.isNotEmpty((String)mapKey) || !StringUtils.isNotEmpty((String)govvalue)) continue;
                System.setProperty(govKey, govvalue);
            }
            returnMap.put("govConfigInfo", resultMap);
            response.setCode(0);
            response.setData(returnMap);
            this.addOpLog(exchange, requestType);
        }
        catch (Exception e) {
            log.error("GovernConfigHandler handle0 exception", (Throwable)e);
            response.setCode(-1);
            response.setMsg(LangRes.get((String)"RpcConfigHandler_1", (String)("\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()), (Object[])new Object[0]));
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private void updateGovConfigInfo(GovConfigInfo govConfigInfo) {
        Map<String, String> govAllMap = GovernConfigManager.getAllGovConfigMap();
        Map govMap = GovConfigInfo.objToMap(govConfigInfo);
        DBRequest dbRequest = new DBRequest();
        for (Map.Entry entry : govMap.entrySet()) {
            String govKey = (String)entry.getKey();
            if (((String)entry.getValue()).equals(govAllMap.get(govKey))) continue;
            String querySql = "select fid from t_monitor_govern_config where fclustername = ? and fgovkey = ?";
            ArrayList queryList = new ArrayList(2);
            Collections.addAll(queryList, Instance.getClusterName(), govKey);
            String insertSql = "insert into t_monitor_govern_config values(?,?,?,?,?)";
            ArrayList insertList = new ArrayList(5);
            Collections.addAll(insertList, ID.genLongId(), Instance.getClusterName(), govKey, (Serializable)entry.getValue(), LocalDateTime.now());
            String updateSql = "update t_monitor_govern_config set fgovvalue= ?,fupdatetime = ? where fclustername = ? and fgovkey = ?";
            ArrayList updateList = new ArrayList(4);
            Collections.addAll(updateList, (Serializable)entry.getValue(), LocalDate.now(), Instance.getClusterName(), govKey);
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
            dbRequest.setInsertRequest(new DBRequest.InsertRequest(insertSql, insertList));
            dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
            boolean isSuccess = MetadataFactory.getStatement().execute((Request)dbRequest);
            if (!isSuccess) {
                log.warn("GovernConfigHandler.updateGovConfigInfo\u4fdd\u5b58\u6570\u636e\u5e93\u672a\u6210\u529f\uff0c\u6570\u636e\u4e0d\u4f1a\u5411Zk\u5199\u5165");
                return;
            }
            StringBuilder sb = new StringBuilder();
            String childrenPath = sb.append(govKey).toString();
            GovernConfigManager.getEyeConfigService().saveConfig(childrenPath, (String)entry.getValue());
        }
    }

    private void addOpLog(HttpExchange exchange, int requestType) {
        if (requestType == 1) {
            // empty if block
        }
        if (requestType == 2) {
            OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"GovernConfigHandler_1", (String)"\u529f\u80fd\u5f00\u5173", (Object[])new Object[0]), LangRes.get((String)"GovernConfigHandler_4", (String)"\u4fee\u6539\u529f\u80fd\u5f00\u5173", (Object[])new Object[0]));
        }
    }
}

