/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.config;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.appha.helper.Utils;
import kd.bos.eye.api.config.manager.UnifiedConfigHookService;
import kd.bos.eye.api.config.manager.UnifiedConfigManager;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.eye.config.custom.ConfigEntity;
import kd.bos.eye.config.custom.ConfigModule;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class UnifiedConfigHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static Log log = LogFactory.getLog(UnifiedConfigHandler.class);
    private static final String QUERY = "query";
    private static final String SAVE = "save";

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(4);
        try {
            UnifiedConfigManager.ConfigParam configParam = ExchangeVueUtils.parseJsonFromPost(exchange, UnifiedConfigManager.ConfigParam.class);
            if (configParam == null) {
                throw new Exception("The params of request monitor config is null.");
            }
            String key = configParam.getKey();
            String module = configParam.getModule();
            String requestType = configParam.getRequestType();
            List<ConfigEntity> configEntities = null;
            if (QUERY.equals(requestType)) {
                configEntities = ConfigDbHelper.getConfigsByKey(key, module);
            } else if (SAVE.equals(requestType)) {
                if (StringUtils.isEmpty((String)module)) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{String.format("The module value: %s is empty", module)});
                }
                ConfigEntity configEntity = ConfigDbHelper.getConfigEntityByKey(key);
                if (configEntity == null) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{String.format("The key: %s does not exist", key)});
                }
                if (!configEntity.getModule().equals(module)) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{"The module value not allowed to be modified"});
                }
                if (!configEntity.getDescription().equals(configParam.getDescription())) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{"The description not allowed to be modified"});
                }
                if ("monitor.oplog.enable".equals(configParam.getKey()) && !configParam.getValue().equals("true") && !configParam.getValue().equals("false")) {
                    response.put("code", -1);
                    response.put("msg", LangRes.get((String)"UnifiedConfigHandler_4", (String)"\u64cd\u4f5c\u65e5\u5fd7\u5f00\u5173\u53ea\u80fd\u586btrue\u6216\u8005false", (Object[])new Object[0]));
                    this.writeJson(JSONUtils.toString(response), exchange);
                    return;
                }
                if ("monitor.oplog.save.days".equals(configParam.getKey())) {
                    if (StringUtils.isNumberString((String)configParam.getValue())) {
                        int oplogDays = Integer.parseInt(configParam.getValue());
                        if (oplogDays <= 0) {
                            response.put("code", -1);
                            response.put("msg", LangRes.get((String)"UnifiedConfigHandler_5", (String)"\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6b63\u786e\u6570\u5b57", (Object[])new Object[0]));
                            this.writeJson(JSONUtils.toString(response), exchange);
                            return;
                        }
                    } else {
                        response.put("code", -1);
                        response.put("msg", LangRes.get((String)"UnifiedConfigHandler_5", (String)"\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6b63\u786e\u6570\u5b57", (Object[])new Object[0]));
                        this.writeJson(JSONUtils.toString(response), exchange);
                        return;
                    }
                }
                if (!configEntity.getValue().equals(configParam.getValue())) {
                    String beforeSaveResult;
                    UnifiedConfigHookService hookService = UnifiedConfigManager.getHookService(module, key);
                    if (hookService != null && StringUtils.isNotEmpty((String)(beforeSaveResult = hookService.beforeSave(key, configParam)))) {
                        response.put("code", -1);
                        response.put("msg", beforeSaveResult);
                        this.writeJson(JSONUtils.toString(response), exchange);
                        return;
                    }
                    if (ConfigDbHelper.updateConfigToDb(configParam)) {
                        UnifiedConfigManager.getEyeConfigService().saveConfig(configParam.getKey(), Utils.OBJECT_MAPPER.writeValueAsString((Object)configParam));
                    }
                    OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"UnifiedConfigHandler_1", (String)"\u53c2\u6570\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"UnifiedConfigHandler_3", (String)"\u628a\u53c2\u6570{0}\u7684\u503c\u4fee\u6539\u4e3a:", (Object[])new Object[]{configParam.getKey()}) + configParam.getValue());
                }
                configEntities = ConfigDbHelper.getAllShowConfigs();
            }
            ArrayList configDatas = new ArrayList();
            if (configEntities != null) {
                Collections.sort(configEntities, Comparator.comparing(ConfigEntity::getKey));
                for (ConfigEntity map : configEntities) {
                    if ("ha.mc.config.init".equals(map.getKey())) continue;
                    HashMap<String, Object> newConfigEntity = new HashMap<String, Object>(7);
                    newConfigEntity.put("id", map.getId());
                    newConfigEntity.put("key", map.getKey());
                    newConfigEntity.put("value", map.getValue());
                    newConfigEntity.put("module", map.getModule());
                    newConfigEntity.put("version", map.getVersion());
                    newConfigEntity.put("description", map.getDescription());
                    newConfigEntity.put("moduleName", ConfigModule.getValueByKey(map.getModule()));
                    newConfigEntity.put("showDescription", LangRes.get((String)("DefaultConfig" + map.getKey()), (String)map.getDescription(), (Object[])new Object[0]));
                    newConfigEntity.put("showModuleName", LangRes.get((String)("ConfigModule" + map.getModule()), (String)map.getModule(), (Object[])new Object[0]));
                    configDatas.add(newConfigEntity);
                }
            }
            HashMap<String, List<Map<String, String>>> resultMap = new HashMap<String, List<Map<String, String>>>(2);
            resultMap.put("moduleData", ConfigModule.configModulesToMap());
            resultMap.put("configData", configDatas);
            response.put("data", resultMap);
            response.put("code", 0);
            response.put("msg", "success");
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("data", null);
            response.put("msg", e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }
}

