/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.config.manager;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.config.manager.UnifiedConfigHookService;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.eye.config.custom.ConfigEntity;
import kd.bos.eye.config.service.EyeConfigChangeListener;
import kd.bos.eye.config.service.EyeConfigService;
import kd.bos.eye.config.service.EyeConfigServiceFactory;
import kd.bos.government.Constant;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class UnifiedConfigManager {
    private static final Log log = LogFactory.getLog(UnifiedConfigManager.class);
    private static final UnifiedConfigChangeListener LISTENER = new UnifiedConfigChangeListener();
    private static final Map<String, UnifiedConfigHookService> CONFIGKEY_HOOK_MAP = new HashMap<String, UnifiedConfigHookService>();
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static EyeConfigService eyeConfigService;

    public static void registerEyeConfigService() {
        ConfigDbHelper.initConfigToDb();
        eyeConfigService = EyeConfigServiceFactory.getEyeConfigService("/runtime/monitor/config/unifiedConfig", scene -> {
            if ("initDataFromDB".equals(scene)) {
                Map<String, String> map = UnifiedConfigManager.getAllUnifiedConfigMap();
                return map;
            }
            if ("schedulePullDataFromDB".equals(scene)) {
                return UnifiedConfigManager.queryLatestModifyUnifiedConfigMap();
            }
            return null;
        }, LISTENER);
    }

    public static EyeConfigService getEyeConfigService() {
        return eyeConfigService;
    }

    private static Map<String, String> queryLatestModifyUnifiedConfigMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        List<ConfigEntity> configEntitys = ConfigDbHelper.getLatestModifyConfig(Constant.MONITOR_CONFIG_SCHEDULE_QUERY_WITHIN_MINUTES);
        if (configEntitys != null && configEntitys.size() > 0) {
            for (ConfigEntity configEntity : configEntitys) {
                String govkey = configEntity.getKey();
                try {
                    map.put(govkey, objectMapper.writeValueAsString((Object)configEntity));
                }
                catch (IOException e) {
                    log.warn((Throwable)e);
                }
            }
        }
        return map;
    }

    private static Map<String, String> getAllUnifiedConfigMap() {
        List<ConfigEntity> configEntityList = ConfigDbHelper.getAllConfigs();
        HashMap<String, String> map = new HashMap<String, String>(8);
        if (configEntityList != null && configEntityList.size() > 0) {
            for (ConfigEntity configEntity : configEntityList) {
                String govkey = configEntity.getKey();
                try {
                    map.put(govkey, objectMapper.writeValueAsString((Object)configEntity));
                }
                catch (Exception e) {
                    log.warn((Throwable)e);
                }
            }
        }
        return map;
    }

    public static void registHookService(String moduleNumber, String key, UnifiedConfigHookService hookService) {
        CONFIGKEY_HOOK_MAP.put(moduleNumber + key, hookService);
    }

    public static UnifiedConfigHookService getHookService(String moduleNumber, String key) {
        return CONFIGKEY_HOOK_MAP.get(moduleNumber + key);
    }

    static {
        objectMapper.registerModule((Module)new JavaTimeModule());
    }

    public static class ConfigParam
    extends ConfigEntity {
        private String requestType;

        public ConfigParam(String requestType) {
            this.requestType = requestType;
        }

        public ConfigParam(String module, String key, String value) {
            super(module, key, value);
        }

        public ConfigParam(String id, String key, String value, String module, int version, int isShow, String description, String requestType) {
            super(id, Instance.getClusterName(), key, value, module, version, isShow, description, LocalDateTime.now());
            this.requestType = requestType;
        }

        public ConfigParam() {
        }

        public String getRequestType() {
            return this.requestType;
        }

        public void setRequestType(String requestType) {
            this.requestType = requestType;
        }
    }

    private static final class UnifiedConfigChangeListener
    implements EyeConfigChangeListener {
        private UnifiedConfigChangeListener() {
        }

        @Override
        public void configUpdate(String key, String value) {
            try {
                ConfigParam configParam = (ConfigParam)objectMapper.readValue(value, ConfigParam.class);
                UnifiedConfigHookService hookService = (UnifiedConfigHookService)CONFIGKEY_HOOK_MAP.get(configParam.getModule() + key);
                if (hookService != null) {
                    hookService.afterSave(key, configParam);
                }
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
        }
    }
}

