/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.api.dashboard.AbstractDashboardHandler;
import kd.bos.eye.api.dashboard.lang.DashboardLangResBundle;
import kd.bos.eye.api.dashboard.vo.Dashboard;
import kd.bos.eye.api.dashboard.vo.DashboardRelation;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class QueryDashboardRelationHandler
extends AbstractDashboardHandler {
    private static final Log log = LogFactory.getLog(QueryDashboardRelationHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle1(HttpExchange exchange) throws IOException {
        ApiResponse<List<Dashboard>> response = new ApiResponse<List<Dashboard>>();
        try {
            DashboardRelation queryParam = ExchangeVueUtils.parseJsonFromPost(exchange, DashboardRelation.class);
            if (queryParam == null || StringUtils.isEmpty((String)queryParam.getOwner())) {
                response.setCode(-1);
                response.setMsg("Fail:The parameter is missing");
                this.writeJson(JSONUtils.toString(response), exchange);
                return;
            }
            List<Dashboard> retList = this.getDashboardByRelation(queryParam.getOwner(), this.isFromCosmiceye(exchange));
            if (DashboardLangResBundle.isNeedTranslate()) {
                for (Dashboard dashboard : retList) {
                    dashboard.setTitle(DashboardLangResBundle.translate(dashboard.getTitle()));
                    dashboard.setRemark(DashboardLangResBundle.translate(dashboard.getRemark()));
                    String translate = DashboardLangResBundle.translateAll(dashboard.getLayout());
                    dashboard.setLayout(translate);
                }
            }
            response.setData(retList);
            response.setCode(0);
            response.setMsg("success");
        }
        catch (Exception e) {
            log.error("Query dashboard error\uff1a", (Throwable)e);
            response.setCode(-1);
            response.setMsg(e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<String> getDashboardsRelation(String owner, boolean isFromCosmiceye) {
        String tableName = isFromCosmiceye ? "t_monitor_cosmiceye_relation" : "t_monitor_dashboard_relation";
        DBRequest dbRequest = new DBRequest();
        String querySql = String.format("select fdashboard from %s where fowner =? ", tableName);
        ArrayList<String> paramList = new ArrayList<String>(1);
        paramList.add(owner);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, paramList));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<String> retList = new ArrayList<String>(result.size());
        for (Result row : result) {
            retList.add(row.getString("fdashboard"));
        }
        return retList;
    }

    private List<Dashboard> getDashboardByRelation(String owner, boolean isFromCosmiceye) {
        if (isFromCosmiceye) {
            return this.getCosmiceyeDashboardByRelation(owner);
        }
        List<String> idList = this.getDashboardsRelation(owner, false);
        String ids = String.join((CharSequence)"','", idList);
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fid,ftitle,fbgimg,flayout,fwidgets,fhome,fremark,fcreated,fupdated,fstyle from t_monitor_dashboard where fid in ('" + ids + "')";
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, new ArrayList()));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<Dashboard> retList = new ArrayList<Dashboard>(result.size());
        for (Result row : result) {
            Dashboard dashboard = new Dashboard();
            dashboard.setId(row.getString("fid"));
            dashboard.setTitle(row.getString("ftitle"));
            dashboard.setBgImg(row.getString("fbgimg"));
            dashboard.setLayout(row.getString("flayout"));
            dashboard.setWidgets(row.getString("fwidgets"));
            boolean home = "1".equals(row.getString("fhome"));
            dashboard.setHome(home);
            dashboard.setRemark(row.getString("fremark"));
            dashboard.setCreated(row.getString("fcreated"));
            dashboard.setUpdated(row.getString("fupdated"));
            dashboard.setDashboardStyle(row.getString("fstyle"));
            retList.add(dashboard);
        }
        return retList;
    }

    private List<Dashboard> getCosmiceyeDashboardByRelation(String owner) {
        List<String> idList = this.getDashboardsRelation(owner, true);
        String ids = String.join((CharSequence)"','", idList);
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fid,ftitle,flevel,flayout,fhome,fremark,fcreated,fupdated,fstyle from t_monitor_cosmiceye_dashboard where fid in ('" + ids + "')";
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, new ArrayList()));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<Dashboard> retList = new ArrayList<Dashboard>(result.size());
        for (Result row : result) {
            Dashboard dashboard = new Dashboard();
            dashboard.setId(row.getString("fid"));
            dashboard.setTitle(row.getString("ftitle"));
            dashboard.setLevel(row.getString("flevel"));
            dashboard.setLayout(row.getString("flayout"));
            boolean home = "1".equals(row.getString("fhome"));
            dashboard.setHome(home);
            dashboard.setRemark(row.getString("fremark"));
            dashboard.setCreated(row.getString("fcreated"));
            dashboard.setUpdated(row.getString("fupdated"));
            dashboard.setDashboardStyle(row.getString("fstyle"));
            retList.add(dashboard);
        }
        return retList;
    }
}

