/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import kd.bos.db.DB;
import kd.bos.eye.api.dashboard.AbstractDashboardHandler;
import kd.bos.eye.api.dashboard.vo.Dashboard;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class SaveDashboardHandler
extends AbstractDashboardHandler {
    private static final Log log = LogFactory.getLog(SaveDashboardHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle1(HttpExchange exchange) throws IOException {
        Dashboard body = ExchangeVueUtils.parseJsonFromPost(exchange, Dashboard.class);
        ApiResponse response = new ApiResponse();
        try {
            body.setTitle(this.cleanXss(body.getTitle()));
            body.setRemark(this.cleanXss(body.getRemark()));
            this.isFromCosmiceye(exchange);
            this.saveDashboard(body, this.isFromCosmiceye(exchange), exchange);
            response.setCode(0);
            response.setMsg("success");
        }
        catch (Exception e) {
            log.error("Save dashboard error:", (Throwable)e);
            response.setCode(-1);
            response.setMsg("Exception:" + e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private void saveDashboard(Dashboard dashboard, boolean isFromCosmiceye, HttpExchange exchange) {
        if (isFromCosmiceye) {
            this.saveCosmiceyeDashboard(dashboard);
            return;
        }
        String bgImg = dashboard.getBgImg() == null ? "" : dashboard.getBgImg();
        String title = dashboard.getTitle() == null ? "" : dashboard.getTitle();
        dashboard.setBgImg(bgImg);
        dashboard.setTitle(title);
        if (StringUtils.isNotEmpty((String)dashboard.getId())) {
            this.updateDashboard(dashboard);
            OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"DashboardHandler_1", (String)"\u76d1\u63a7\u5927\u76d8", (Object[])new Object[0]), LangRes.get((String)"DashboardHandler_5", (String)"\u4fee\u6539\u76d1\u63a7\u5927\u76d8", (Object[])new Object[0]));
            return;
        }
        dashboard.setId(DB.genStringId((String)"t_monitor_dashboard"));
        ArrayList<Object> paramList = new ArrayList<Object>(9);
        paramList.add(dashboard.getId());
        paramList.add(dashboard.getTitle());
        paramList.add(dashboard.getBgImg());
        paramList.add(dashboard.isHome());
        paramList.add(dashboard.getLayout());
        paramList.add(dashboard.getWidgets());
        paramList.add(dashboard.getRemark());
        paramList.add(dashboard.getDashboardStyle());
        String sql = "insert into t_monitor_dashboard values(?,?,?,?,?,?,?,now(),now(),?)";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
        OPLOGGER.opLog(exchange, OpType.ADD, LangRes.get((String)"DashboardHandler_1", (String)"\u76d1\u63a7\u5927\u76d8", (Object[])new Object[0]), LangRes.get((String)"DashboardHandler_6", (String)"\u65b0\u589e\u76d1\u63a7\u5927\u76d8", (Object[])new Object[0]));
    }

    private void updateDashboard(Dashboard dashboard) {
        ArrayList<Object> paramList = new ArrayList<Object>(7);
        paramList.add(dashboard.getTitle());
        paramList.add(dashboard.getBgImg());
        paramList.add(dashboard.isHome());
        paramList.add(dashboard.getLayout());
        paramList.add(dashboard.getWidgets());
        paramList.add(dashboard.getRemark());
        paramList.add(dashboard.getDashboardStyle());
        paramList.add(dashboard.getId());
        String updateSql = "update t_monitor_dashboard set ftitle=?, fbgimg=?, fhome=?, flayout=?, fwidgets=?, fremark=?, fstyle=?, fupdated=now() where fid=?";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, paramList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    private void saveCosmiceyeDashboard(Dashboard dashboard) {
        if (StringUtils.isNotEmpty((String)dashboard.getId())) {
            this.updateCosmiceyeDashboard(dashboard);
            return;
        }
        dashboard.setId(DB.genStringId((String)"t_monitor_cosmiceye_dashboard"));
        ArrayList<Object> paramList = new ArrayList<Object>(7);
        paramList.add(dashboard.getId());
        paramList.add(dashboard.getTitle());
        paramList.add(dashboard.getLevel());
        paramList.add(dashboard.isHome());
        paramList.add(dashboard.getLayout());
        paramList.add(dashboard.getRemark());
        paramList.add(dashboard.getDashboardStyle());
        String sql = "insert into t_monitor_cosmiceye_dashboard values(?,?,?,?,?,?,?,now(),now())";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    private void updateCosmiceyeDashboard(Dashboard dashboard) {
        ArrayList<Object> paramList = new ArrayList<Object>(7);
        paramList.add(dashboard.getTitle());
        paramList.add(dashboard.getLevel());
        paramList.add(dashboard.isHome());
        paramList.add(dashboard.getLayout());
        paramList.add(dashboard.getRemark());
        paramList.add(dashboard.getDashboardStyle());
        paramList.add(dashboard.getId());
        String updateSql = "update t_monitor_cosmiceye_dashboard set ftitle=?, flevel=?, fhome=?, flayout=?, fremark=?, fstyle=?, fupdated=now() where fid=?";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, paramList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    private String cleanXss(String message) {
        if (!StringUtils.isEmpty((String)message)) {
            message = message.replaceAll("'", "&#39;");
            message = message.replaceAll("<", "&lt;");
            message = message.replaceAll(">", "&gt;");
            message = message.replaceAll("\"", "&quot;");
            message = message.replaceAll("'", "&#x27;");
            message = message.replaceAll("/", "&#x2f;");
        }
        return message;
    }
}

