/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.init;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.eye.api.dashboard.vo.Dashboard;
import kd.bos.eye.api.dashboard.vo.DashboardRelation;
import kd.bos.eye.api.dashboard.vo.Widgets;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class CosmiceyeDashboardHelper {
    private static Log log = LogFactory.getLog(CosmiceyeDashboardHelper.class);

    public static void doInit() {
        CosmiceyeDashboardHelper.initDashboard();
        CosmiceyeDashboardHelper.initRelation();
        CosmiceyeDashboardHelper.initWidgets();
    }

    private static void initDashboard() {
        String json = CosmiceyeDashboardHelper.parseJsonData("cosmiceye_dashboard.json");
        if (StringUtils.isNotEmpty((String)json)) {
            try {
                if (CosmiceyeDashboardHelper.isExistData("t_monitor_cosmiceye_dashboard")) {
                    return;
                }
                List dashboards = (List)JSONUtils.cast((String)json, List.class, (Class[])new Class[]{Dashboard.class});
                for (Dashboard dashboard : dashboards) {
                    CosmiceyeDashboardHelper.insertCosmicDashboard(dashboard);
                }
            }
            catch (Exception e) {
                log.error("CosmiceyeDashboardHelper init t_monitor_cosmiceye_dashboard data error", (Throwable)e);
            }
        }
    }

    private static void initRelation() {
        String json = CosmiceyeDashboardHelper.parseJsonData("cosmiceye_relation.json");
        if (StringUtils.isNotEmpty((String)json)) {
            try {
                if (CosmiceyeDashboardHelper.isExistData("t_monitor_cosmiceye_relation")) {
                    return;
                }
                List relations = (List)JSONUtils.cast((String)json, List.class, (Class[])new Class[]{DashboardRelation.class});
                for (DashboardRelation relation : relations) {
                    CosmiceyeDashboardHelper.insertDashboardRelation(relation);
                }
            }
            catch (Exception e) {
                log.error("CosmiceyeDashboardHelper init t_monitor_dashboard_relation data error", (Throwable)e);
            }
        }
    }

    private static void initWidgets() {
        String json = CosmiceyeDashboardHelper.parseJsonData("cosmiceye_widgets.json");
        if (StringUtils.isNotEmpty((String)json)) {
            try {
                if (CosmiceyeDashboardHelper.isExistData("t_monitor_cosmiceye_widgets")) {
                    return;
                }
                List widgetsList = (List)JSONUtils.cast((String)json, List.class, (Class[])new Class[]{Widgets.class});
                for (Widgets widgets : widgetsList) {
                    CosmiceyeDashboardHelper.insertCosmicWidgets(widgets);
                }
            }
            catch (Exception e) {
                log.error("CosmiceyeDashboardHelper init t_monitor_cosmiceye_widgets data error", (Throwable)e);
            }
        }
    }

    private static boolean isExistData(String tableName) {
        String sql = "SELECT COUNT(*) AS num FROM " + tableName;
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql, Collections.EMPTY_LIST));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        String totalNum = ((Result)results.get(0)).getString("num");
        return Integer.parseInt(totalNum) > 0;
    }

    private static String parseJsonData(String fileName) {
        StringBuilder sb = new StringBuilder();
        try (InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("scripts/" + fileName);
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            log.warn("CosmiceyeDashboardHelper parseJsonData data error", (Throwable)e);
        }
        return sb.toString();
    }

    private static void insertCosmicDashboard(Dashboard dashboard) {
        ArrayList<Object> paramList = new ArrayList<Object>(7);
        paramList.add(dashboard.getId());
        paramList.add(dashboard.getTitle());
        paramList.add(dashboard.getLevel());
        paramList.add(dashboard.isHome());
        paramList.add(dashboard.getLayout());
        paramList.add(dashboard.getRemark());
        paramList.add(dashboard.getDashboardStyle());
        String sql = "insert into t_monitor_cosmiceye_dashboard values(?,?,?,?,?,?,?,now(),now())";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    private static void insertDashboardRelation(DashboardRelation relation) {
        String tableName = "t_monitor_cosmiceye_relation";
        ArrayList<Object> paramList = new ArrayList<Object>(4);
        paramList.add(relation.getId());
        paramList.add(relation.getOwner());
        paramList.add(relation.getDashboardId());
        paramList.add(relation.getSort());
        String sql = String.format("insert into %s values(?,?,?,?)", tableName);
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    private static void insertCosmicWidgets(Widgets widget) {
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        paramList.add(widget.getId());
        paramList.add(widget.getTitle());
        paramList.add(widget.getMetrics());
        paramList.add(widget.isUsed());
        paramList.add(widget.getChartName());
        paramList.add(widget.getChartType());
        paramList.add(widget.getValueType());
        String sql = "insert into t_monitor_cosmiceye_widgets values(?,?,?,?,?,?,?,now(),now())";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }
}

