/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.commom;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.eye.api.dashboard.metrics.entity.ArmorCondition;
import kd.bos.eye.api.dashboard.metrics.impl.IQueryEsDaoImpl;
import kd.bos.eye.api.log.LogQuery;
import kd.bos.eye.api.log.LogQueryFactory;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.instance.Instance;
import kd.bos.metric.MetricSystem;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

public class ApiMetricsCollector {
    private static int INTERVAL_SECONDS = 12;
    private static long LIMIT_INTERVAL_SECONDS = 20L;
    private static final String APT_METRICS_LIMIT_INTERVAL = "gov.reporter.apimetric.interval";
    private static final String ALARM_COUNT_METRIC_ENABLE = "gov.reporter.alarmmetric.enable";
    private static ConcurrentHashMap<String, LastRecord> recordMap = new ConcurrentHashMap();
    private static final String SLOW_TYPE_KEY = "slowQueryType";
    private static final String SLOW_CLASS = "kd.bos.slowlog.SlowLogger";
    private static final String CLASS_NAME = "className";

    public static void registerApiMetrics() {
        MetricSystem.registerGauge((String)"kd.metrics.api.totalRequest", () -> ApiMetricsCollector.totalRequest());
        MetricSystem.registerGauge((String)"kd.metrics.api.totalRt", () -> ApiMetricsCollector.totalRt());
        MetricSystem.registerGauge((String)"kd.metrics.api.avgRt", () -> ApiMetricsCollector.avgRt());
        MetricSystem.registerGauge((String)"kd.metrics.api.qps", () -> ApiMetricsCollector.qps());
        MetricSystem.registerGauge((String)"kd.metrics.slowQuery.count.web", () -> ApiMetricsCollector.slowQueryCount("web"));
        MetricSystem.registerGauge((String)"kd.metrics.slowQuery.count.rpc", () -> ApiMetricsCollector.slowQueryCount("rpc"));
        MetricSystem.registerGauge((String)"kd.metrics.slowQuery.count.sql", () -> ApiMetricsCollector.slowQueryCount("sql"));
        MetricSystem.registerGauge((String)"kd.metrics.alarm.count.low", () -> ApiMetricsCollector.alarmCount("LOW"));
        MetricSystem.registerGauge((String)"kd.metrics.alarm.count.serious", () -> ApiMetricsCollector.alarmCount("SERIOUS"));
        MetricSystem.registerGauge((String)"kd.metrics.alarm.count.disaster", () -> ApiMetricsCollector.alarmCount("DISASTER"));
    }

    private static long totalRequest() {
        long data = 0L;
        String key = "totalRequest";
        if (!ApiMetricsCollector.isNeedQuery(key)) {
            data = recordMap.get(key).getVal();
        } else {
            IQueryEsDaoImpl dao = new IQueryEsDaoImpl();
            Double total = dao.queryTotalRequest(ApiMetricsCollector.createCondition());
            data = Math.round(total);
            recordMap.put(key, new LastRecord(System.currentTimeMillis(), (int)data));
        }
        return data;
    }

    private static long totalRt() {
        long data = 0L;
        String key = "totalRt";
        if (!ApiMetricsCollector.isNeedQuery(key)) {
            data = recordMap.get(key).getVal();
        } else {
            IQueryEsDaoImpl dao = new IQueryEsDaoImpl();
            Double total = dao.queryTotalRt(ApiMetricsCollector.createCondition());
            data = Math.round(total);
            recordMap.put(key, new LastRecord(System.currentTimeMillis(), (int)data));
        }
        return data;
    }

    private static long avgRt() {
        long data = 0L;
        String key = "avgRt";
        if (!ApiMetricsCollector.isNeedQuery(key)) {
            data = recordMap.get(key).getVal();
        } else {
            long totalQeq = ApiMetricsCollector.totalRequest();
            data = totalQeq == 0L ? 0L : ApiMetricsCollector.totalRt() / totalQeq;
            recordMap.put(key, new LastRecord(System.currentTimeMillis(), (int)data));
        }
        return data;
    }

    private static long qps() {
        long data = 0L;
        String key = "qps";
        if (!ApiMetricsCollector.isNeedQuery(key)) {
            data = recordMap.get(key).getVal();
        } else {
            data = ApiMetricsCollector.totalRequest() / (long)INTERVAL_SECONDS;
            recordMap.put(key, new LastRecord(System.currentTimeMillis(), (int)data));
        }
        return data;
    }

    private static ArmorCondition createCondition() {
        String ip = NetAddressUtils.getLocalIpAddress();
        ArmorCondition condition = new ArmorCondition();
        condition.setIp(ip);
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -INTERVAL_SECONDS);
        condition.setStart(calendar.getTime());
        condition.setEnd(new Date());
        return condition;
    }

    private static long slowQueryCount(String type) {
        if (!DBHelper.dbIsConfigured()) {
            return 0L;
        }
        int count = 0;
        if (ApiMetricsCollector.isNeedQuery(type)) {
            String ip = NetAddressUtils.getLocalIpAddress();
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, -INTERVAL_SECONDS);
            HashMap<String, String> condition = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((String)type)) {
                if ("web".equals(type.toLowerCase(Locale.ENGLISH))) {
                    condition.put(SLOW_TYPE_KEY, "SlowLogger-WEB");
                } else if ("rpc".equals(type.toLowerCase(Locale.ENGLISH))) {
                    condition.put(SLOW_TYPE_KEY, "SlowLogger-RPC");
                } else if ("sql".equals(type.toLowerCase(Locale.ENGLISH))) {
                    condition.put(SLOW_TYPE_KEY, "SlowLogger-JDBC");
                } else {
                    condition.put(SLOW_TYPE_KEY, type);
                }
            }
            if (StringUtils.isNotEmpty((String)ip)) {
                condition.put("ip", ip);
            }
            condition.put(CLASS_NAME, SLOW_CLASS);
            LogQuery query = LogQueryFactory.getLogQuery();
            count = query.countLogQuery(calendar.getTime(), new Date(), condition);
            recordMap.put(type, new LastRecord(System.currentTimeMillis(), count));
        } else {
            count = recordMap.get(type).getVal();
        }
        return count;
    }

    private static boolean alarmCollectorEnable() {
        return "true".equals(System.getProperty(ALARM_COUNT_METRIC_ENABLE, "true"));
    }

    private static long alarmCount(String type) {
        if (!DBHelper.dbIsConfigured() || !ApiMetricsCollector.alarmCollectorEnable()) {
            return 0L;
        }
        long data = 0L;
        if (!ApiMetricsCollector.isNeedQuery(type)) {
            data = recordMap.get(type).getVal();
        } else {
            try {
                String sql = "select count(*) as num from t_monitor_alarm_record where FSTATE = 'ALARM' and flevel ='%s' and fip = '%s'";
                String instanceId = Instance.getInstanceId();
                DBRequest dbRequest = new DBRequest();
                dbRequest.setQueryRequest(new DBRequest.QueryRequest(String.format(sql, type, instanceId), Collections.EMPTY_LIST));
                List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
                data = ((Result)results.get(0)).getLong("num");
                recordMap.put(type, new LastRecord(System.currentTimeMillis(), (int)data));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return data;
    }

    private static boolean isNeedQuery(String key) {
        LastRecord last = recordMap.get(key);
        long limit = Long.getLong(APT_METRICS_LIMIT_INTERVAL, LIMIT_INTERVAL_SECONDS);
        long currentTime = System.currentTimeMillis();
        boolean needQuery = last == null || currentTime - last.lastTimestamp >= limit * 1000L;
        return needQuery;
    }

    private static class LastRecord {
        private long lastTimestamp;
        private int val;

        public LastRecord(long lastTimestamp, int val) {
            this.lastTimestamp = lastTimestamp;
            this.val = val;
        }

        public long getLastTimestamp() {
            return this.lastTimestamp;
        }

        public void setLastTimestamp(long lastTimestamp) {
            this.lastTimestamp = lastTimestamp;
        }

        public int getVal() {
            return this.val;
        }

        public void setVal(int val) {
            this.val = val;
        }
    }
}

