/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.eye.api.dashboard.es.EsClient;
import kd.bos.eye.api.dashboard.metrics.dao.IMetricsEsDao;
import kd.bos.eye.api.dashboard.metrics.entity.BaseMetricsResult;
import kd.bos.eye.api.dashboard.metrics.entity.MetricsCondition;
import kd.bos.eye.api.dashboard.metrics.entity.MetricsResultData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.avg.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.max.ParsedMax;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class IMetricsEsDaoImpl
implements IMetricsEsDao {
    private static final Log logger = LogFactory.getLog(IMetricsEsDaoImpl.class);
    private static final String MAX_VALUE = "maxValue";
    private static final String AVG_VALUE = "avgValue";
    private static final String REAL_TIME_VALUE = "realTimeValue";
    private static final int METRICS_QUERY_DATA_MAX_LINES = 10000;
    private static final int DELAY_TIME = 30;

    @Override
    public BaseMetricsResult queryMetricsMax(MetricsCondition condition) {
        ParsedMax max;
        Aggregations aggregations;
        Double val = new Double(0.0);
        BaseMetricsResult result = new BaseMetricsResult();
        result.setMetrics(condition.getMetrics());
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.size(0);
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.max((String)MAX_VALUE).field(condition.getMetrics()));
        SearchResponse response = this.queryEsResponse(sourceBuilder, condition);
        if (response != null && response.status().getStatus() == 200 && (aggregations = response.getAggregations()) != null && (max = (ParsedMax)aggregations.get(MAX_VALUE)) != null && max.getValue() != Double.POSITIVE_INFINITY) {
            val = max.getValue();
        }
        result.setVal(val);
        return result;
    }

    @Override
    public BaseMetricsResult queryMetricsAvg(MetricsCondition condition) {
        ParsedAvg avg;
        Aggregations aggregations;
        Double val = new Double(0.0);
        BaseMetricsResult result = new BaseMetricsResult();
        result.setMetrics(condition.getMetrics());
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.size(0);
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.avg((String)AVG_VALUE).field(condition.getMetrics()));
        SearchResponse response = this.queryEsResponse(sourceBuilder, condition);
        if (response != null && response.status().getStatus() == 200 && (aggregations = response.getAggregations()) != null && (avg = (ParsedAvg)aggregations.get(AVG_VALUE)) != null && avg.getValue() != Double.POSITIVE_INFINITY) {
            val = avg.getValue();
        }
        result.setVal(val);
        return result;
    }

    @Override
    public BaseMetricsResult queryMetricsRealTime(MetricsCondition condition) {
        SearchHit[] hits;
        BaseMetricsResult result = new BaseMetricsResult();
        Calendar calendar = Calendar.getInstance();
        int delayTime = condition.getRealDelayTime() > 0 ? condition.getRealDelayTime() : 30;
        calendar.add(13, -delayTime);
        condition.setStart(calendar.getTime());
        condition.setEnd(new Date());
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.size(1);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.fetchSource(condition.getMetrics(), null);
        sourceBuilder.sort("timestamp", SortOrder.DESC);
        sourceBuilder.size(1);
        SearchResponse response = this.queryEsResponse(sourceBuilder, condition);
        if (response != null && response.status().getStatus() == 200 && (hits = response.getHits().getHits()).length > 0) {
            SearchHit hit = hits[0];
            String json = hit.getSourceAsString().replace(condition.getMetrics(), "val");
            result = (BaseMetricsResult)JSONObject.parseObject((String)json, BaseMetricsResult.class);
        }
        result.setMetrics(condition.getMetrics());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MetricsResultData> queryMetricsRange(MetricsCondition condition) {
        String metrics = condition.getMetrics();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.size(condition.getPageSize());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.fetchSource(condition.getIncludeFields(), null);
        sourceBuilder.sort("timestamp", condition.getSortOrder());
        SearchResponse searchResponse = null;
        if (condition.getStart() == null) {
            throw new RuntimeException("Dashboard Metrics:query metrics start time is null.");
        }
        if (condition.getEnd() == null) {
            condition.setEnd(new Date());
        }
        EsClient esClient = new EsClient();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(condition.getIndices());
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)condition.getStart().getTime()).lte((Object)condition.getEnd().getTime()));
        if (StringUtils.isNotEmpty((String)condition.getAppName())) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"appName.keyword", (String[])new String[]{condition.getAppName()}));
        }
        if (StringUtils.isNotEmpty((String)condition.getInstanceId())) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"instanceId.keyword", (String[])new String[]{condition.getInstanceId()}));
        }
        if (StringUtils.isNotEmpty((String)condition.getIp())) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"ip.keyword", (String[])new String[]{condition.getIp()}));
        }
        if (StringUtils.isNotEmpty((String)condition.getMetrics())) {
            // empty if block
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        if (condition.getIncludeFields().length > 0) {
            sourceBuilder.fetchSource(condition.getIncludeFields(), new String[0]);
        }
        searchRequest.source(sourceBuilder);
        searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        ArrayList<MetricsResultData> resultData = new ArrayList<MetricsResultData>(16);
        try {
            searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
            if (searchResponse != null && searchResponse.status().getStatus() == 200) {
                if (searchResponse.getHits().getTotalHits() > 10000L) {
                    throw new RuntimeException("Query metrics data from es exception: The result is too large!");
                }
                SearchHit[] hits = searchResponse.getHits().getHits();
                while (hits.length > 0) {
                    for (SearchHit hit : hits) {
                        String hitStr = hit.getSourceAsString().replace(metrics, "val");
                        MetricsResultData data = (MetricsResultData)JSONObject.parseObject((String)hitStr, MetricsResultData.class);
                        data.setMetrics(metrics);
                        resultData.add(data);
                    }
                    SearchHit last = hits[hits.length - 1];
                    sourceBuilder.searchAfter(last.getSortValues());
                    searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
                    hits = searchResponse.getHits().getHits();
                }
            }
        }
        catch (Exception e) {
            logger.error("Dashboard query es error, msg={}", (Object)e.getMessage());
        }
        finally {
            esClient.close();
        }
        return resultData;
    }

    @Override
    public SearchResponse queryMetricsRange(MetricsCondition condition, SearchSourceBuilder sourceBuilder) {
        SearchResponse response = this.queryEsResponse(sourceBuilder, condition);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResponse queryEsResponse(SearchSourceBuilder sourceBuilder, MetricsCondition condition) {
        SearchResponse searchResponse = null;
        if (condition.getStart() == null) {
            throw new RuntimeException("Dashboard Metrics:query metrics start time is null.");
        }
        if (condition.getEnd() == null) {
            condition.setEnd(new Date());
        }
        EsClient esClient = new EsClient();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(condition.getIndices());
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)condition.getStart().getTime()).lte((Object)condition.getEnd().getTime()));
        if (StringUtils.isNotEmpty((String)condition.getAppName())) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"appName.keyword", (String[])new String[]{condition.getAppName()}));
        }
        if (StringUtils.isNotEmpty((String)condition.getInstanceId())) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"instanceId.keyword", (String[])new String[]{condition.getInstanceId()}));
        }
        if (StringUtils.isNotEmpty((String)condition.getIp())) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"ip.keyword", (String[])new String[]{condition.getIp()}));
        }
        if (StringUtils.isNotEmpty((String)condition.getMetrics())) {
            // empty if block
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        if (condition.getIncludeFields().length > 0) {
            sourceBuilder.fetchSource(condition.getIncludeFields(), new String[0]);
        }
        searchRequest.source(sourceBuilder);
        searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        try {
            searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            logger.error("Dashboard query es error, msg={}", (Object)e.getMessage());
        }
        finally {
            esClient.close();
        }
        return searchResponse;
    }
}

