/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.eye.api.dashboard.es.EsClient;
import kd.bos.eye.api.dashboard.metrics.dao.IQueryEsDao;
import kd.bos.eye.api.dashboard.metrics.entity.ArmorCondition;
import kd.bos.eye.api.dashboard.metrics.entity.AverageRt;
import kd.bos.eye.api.dashboard.metrics.entity.EsFieldEnum;
import kd.bos.eye.api.dashboard.metrics.entity.Throughput;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.sum.ParsedSum;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class IQueryEsDaoImpl
implements IQueryEsDao {
    private static final Log logger = LogFactory.getLog(IQueryEsDaoImpl.class);

    @Override
    public List<AverageRt> queryAvgRt(ArmorCondition condition) {
        Aggregations aggregations;
        List<AverageRt> data = new ArrayList<AverageRt>(16);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg_timestamp").field("timestamp")).size(20000);
        componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)EsFieldEnum.AVERAGE_RT.getAggName()).field(EsFieldEnum.AVERAGE_RT.getField()));
        sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
        sourceBuilder.sort("timestamp", SortOrder.ASC);
        SearchResponse response = this.queryEsResponse(sourceBuilder, condition);
        if (response != null && response.status().getStatus() == 200 && (aggregations = response.getAggregations()) != null) {
            Terms signature = (Terms)aggregations.get("agg_timestamp");
            for (Terms.Bucket bucket : signature.getBuckets()) {
                long docCount = bucket.getDocCount();
                docCount = docCount > 0L ? docCount : 1L;
                ParsedSum sumAverageRt = (ParsedSum)bucket.getAggregations().get(EsFieldEnum.AVERAGE_RT.getAggName());
                Double averageRt = sumAverageRt.getValue() / (double)docCount;
                Long timestamp = Long.valueOf(bucket.getKeyAsString());
                AverageRt rt = new AverageRt(averageRt, timestamp);
                data.add(rt);
            }
        }
        if (!data.isEmpty()) {
            data = data.stream().sorted(Comparator.comparing(AverageRt::getTimestamp)).collect(Collectors.toList());
        }
        return data;
    }

    @Override
    public List<Throughput> queryThroughput(ArmorCondition condition) {
        Aggregations aggregations;
        List<Throughput> data = new ArrayList<Throughput>(16);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        TermsAggregationBuilder componentBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg_timestamp").field("timestamp")).size(20000);
        componentBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)EsFieldEnum.TOTAL_QPS.getAggName()).field(EsFieldEnum.TOTAL_QPS.getField()));
        sourceBuilder.aggregation((AggregationBuilder)componentBuilder);
        sourceBuilder.sort("timestamp", SortOrder.ASC);
        SearchResponse response = this.queryEsResponse(sourceBuilder, condition);
        if (response != null && response.status().getStatus() == 200 && (aggregations = response.getAggregations()) != null) {
            Terms signature = (Terms)aggregations.get("agg_timestamp");
            for (Terms.Bucket bucket : signature.getBuckets()) {
                ParsedSum sumTotalQps = (ParsedSum)bucket.getAggregations().get(EsFieldEnum.TOTAL_QPS.getAggName());
                Double totalQps = new Double(sumTotalQps.getValue());
                Long timestamp = Long.valueOf(bucket.getKeyAsString());
                Throughput throughput = new Throughput(totalQps, timestamp);
                data.add(throughput);
            }
        }
        if (!data.isEmpty()) {
            data = data.stream().sorted(Comparator.comparing(Throughput::getTimestamp)).collect(Collectors.toList());
        }
        return data;
    }

    @Override
    public Double queryTotalRequest(ArmorCondition condition) {
        Aggregations aggregations;
        Double total = new Double(0.0);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.sum((String)EsFieldEnum.TOTAL_QPS.getAggName()).field(EsFieldEnum.TOTAL_QPS.getField()));
        SearchResponse response = this.queryEsResponse(sourceBuilder, condition);
        if (response != null && response.status().getStatus() == 200 && (aggregations = response.getAggregations()) != null) {
            ParsedSum sumTotalQps = (ParsedSum)aggregations.get(EsFieldEnum.TOTAL_QPS.getAggName());
            total = new Double(sumTotalQps.getValue());
        }
        return total;
    }

    @Override
    public Double queryTotalRt(ArmorCondition condition) {
        Aggregations aggregations;
        Double total = new Double(0.0);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.sum((String)EsFieldEnum.TOTAL_RT.getAggName()).field(EsFieldEnum.TOTAL_RT.getField()));
        SearchResponse response = this.queryEsResponse(sourceBuilder, condition);
        if (response != null && response.status().getStatus() == 200 && (aggregations = response.getAggregations()) != null) {
            ParsedSum sumTotalRt = (ParsedSum)aggregations.get(EsFieldEnum.TOTAL_RT.getAggName());
            total = new Double(sumTotalRt.getValue());
        }
        return total;
    }

    @Override
    public Double queryAvgRtVal(ArmorCondition condition) {
        ParsedAvg avg;
        Aggregations aggregations;
        Double avgRtVal = new Double(0.0);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.avg((String)EsFieldEnum.AVERAGE_RT.getAggName()).field(EsFieldEnum.AVERAGE_RT.getField()));
        SearchResponse response = this.queryEsResponse(sourceBuilder, condition);
        if (response != null && response.status().getStatus() == 200 && (aggregations = response.getAggregations()) != null && (avg = (ParsedAvg)aggregations.get(EsFieldEnum.AVERAGE_RT.getAggName())) != null && avg.getValue() != Double.POSITIVE_INFINITY) {
            avgRtVal = new Double(avg.getValue());
        }
        return avgRtVal;
    }

    @Override
    public Double queryThroughputVal(ArmorCondition condition) {
        ParsedSum sum;
        Aggregations aggregations;
        Double avgThroughputVal = new Double(0.0);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.sum((String)EsFieldEnum.TOTAL_QPS.getAggName()).field(EsFieldEnum.TOTAL_QPS.getField()));
        SearchResponse response = this.queryEsResponse(sourceBuilder, condition);
        if (response != null && response.status().getStatus() == 200 && (aggregations = response.getAggregations()) != null && (sum = (ParsedSum)aggregations.get(EsFieldEnum.TOTAL_QPS.getAggName())) != null && sum.getValue() != Double.POSITIVE_INFINITY) {
            long seconds = (condition.getEnd().getTime() - condition.getStart().getTime()) / 1000L;
            avgThroughputVal = sum.getValue() / (double)seconds;
        }
        return avgThroughputVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResponse queryEsResponse(SearchSourceBuilder sourceBuilder, ArmorCondition condition) {
        SearchResponse searchResponse = null;
        if (condition.getStart() == null) {
            throw new RuntimeException("Dashboard Metrics:query metrics start time is null.");
        }
        if (condition.getEnd() == null) {
            condition.setEnd(new Date());
        }
        EsClient esClient = new EsClient();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(condition.getIndices());
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)condition.getStart().getTime()).lte((Object)condition.getEnd().getTime()));
        if (StringUtils.isNotEmpty((String)condition.getAppName())) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"appName.keyword", (String[])new String[]{condition.getAppName()}));
        }
        if (StringUtils.isNotEmpty((String)condition.getInstanceId())) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"instanceId.keyword", (String[])new String[]{condition.getInstanceId()}));
        }
        if (StringUtils.isNotEmpty((String)condition.getIp())) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"ip", (String[])new String[]{condition.getIp()}));
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.size(0);
        searchRequest.source(sourceBuilder);
        searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        try {
            searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            logger.error("Dashboard query es error, msg={}", (Object)e.getMessage());
        }
        finally {
            esClient.close();
        }
        return searchResponse;
    }
}

