/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.dashboard.metrics.base.TopChartData;
import kd.bos.eye.api.dashboard.metrics.commom.MetricsUtils;
import kd.bos.eye.api.dashboard.metrics.query.api.APITopNQuery;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.govern.GovernConfigs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.StringUtils;

public abstract class APITopNMetricsAbstractHandler
implements IMetricsData {
    private static final Log log = LogFactory.getLog(APITopNMetricsAbstractHandler.class);
    protected static final String XAXIS = "xAxis";
    protected static final String YAXIS = "yAxis";
    protected static final String API_CALLS = "API\u8c03\u7528\u6b21\u6570";
    protected static final String API_RT = "API\u54cd\u5e94\u65f6\u95f4(\u6beb\u79d2)";
    protected static final String TOP_VALUE_PARA_KEY = "topN";

    protected static String getApiCalls() {
        return LangRes.get((String)"APITopNMetricsAbstractHandler_0", (String)"API call count", (Object[])new Object[0]);
    }

    protected static String getApiRt() {
        return LangRes.get((String)"APITopNMetricsAbstractHandler_1", (String)"API Response Time (milliseconds)", (Object[])new Object[0]);
    }

    protected int getTopN(BaseQueryParameter parameter) {
        int topN = 5;
        try {
            int inputTopNNum;
            String inputTopN = parameter.getExtensionParameter().get(TOP_VALUE_PARA_KEY);
            if (StringUtils.isNumericString((String)inputTopN) && (inputTopNNum = Integer.parseInt(inputTopN)) >= 0 && inputTopNNum <= 10) {
                topN = inputTopNNum;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return topN;
    }

    protected boolean checkApiCallEnable() {
        TopChartData topData = new TopChartData();
        if (!GovernConfigs.getApicallEnable()) {
            log.error("Dashborad -->gov.apicall.enable=false");
            return false;
        }
        return true;
    }

    protected TopChartData loadData(String type, BaseQueryParameter parameter) {
        TopChartData topData = new TopChartData();
        if (this.checkApiCallEnable()) {
            HashMap a;
            int topN = this.getTopN(parameter);
            ArrayList<String> legends = new ArrayList<String>();
            Map<String, Object> data = APITopNQuery.query(MetricsUtils.parseDate(parameter.getStartTime()), MetricsUtils.parseDate(parameter.getEndTime()), type, topN);
            if (type.equals("hotAPI")) {
                legends.add(APITopNMetricsAbstractHandler.getApiCalls());
                a = (HashMap)data.get("count");
            } else {
                legends.add(APITopNMetricsAbstractHandler.getApiRt());
                a = (HashMap)data.get("time");
            }
            Object[] dataXObject = (Object[])a.get(XAXIS);
            Object[] dataYObject = (Object[])a.get(YAXIS);
            ArrayList<String> xData = new ArrayList<String>(16);
            HashMap<String, List<Object>> yData = new HashMap<String, List<Object>>(16);
            ArrayList<Double> yDataList = new ArrayList<Double>(dataXObject.length);
            for (int i = dataXObject.length - 1; i >= 0; --i) {
                String xdata = String.valueOf(dataYObject[i]);
                String ydata = String.valueOf(dataXObject[i]);
                xData.add(xdata);
                yDataList.add(Double.valueOf(ydata));
            }
            yData.put((String)legends.get(0), (List<Object>)yDataList);
            topData.setLegend(legends);
            topData.setxData(xData);
            topData.setyData(yData);
        }
        return topData;
    }
}

