/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.common;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.eye.api.dashboard.metrics.commom.MetricsUtils;
import kd.bos.eye.api.dashboard.metrics.entity.ExtChartData;
import kd.bos.eye.api.dashboard.metrics.entity.MetricsCondition;
import kd.bos.eye.api.dashboard.metrics.entity.MetricsResultData;
import kd.bos.eye.api.dashboard.metrics.impl.IMetricsEsDaoImpl;
import kd.bos.eye.spi.BaseChartData;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class InstanceMetricsHandler
implements IMetricsData {
    private static final String TYPE_KEY = "realTime";
    private static final Log log = LogFactory.getLog(InstanceMetricsHandler.class);
    private static final int RESPONSE_MAX_DATA_SIZE = 10000;

    @Override
    public BaseChartData query(BaseQueryParameter parameter) {
        SimpleDateFormat dateFormatForView = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ExtChartData chartData = new ExtChartData();
        String start = parameter.getStartTime();
        String end = parameter.getEndTime();
        String queryMetrics = parameter.getExtensionParameter().get("queryMetrics");
        String valueType = parameter.getExtensionParameter().get("valueType");
        String unit = parameter.getExtensionParameter().get("unit");
        String instanceId = parameter.getExtensionParameter().get("instanceId");
        String legend = parameter.getExtensionParameter().get("legend");
        String unitExp = parameter.getExtensionParameter().get("unitExp");
        if (StringUtils.isEmpty((String)instanceId)) {
            this.logError("not input instanceId!");
            return chartData;
        }
        if (StringUtils.isEmpty((String)legend)) {
            this.logError("not input instanceId!");
            return chartData;
        }
        if (StringUtils.isEmpty((String)queryMetrics) || !queryMetrics.toLowerCase(Locale.ENGLISH).startsWith("kd.metrics.")) {
            this.logError("not input metrics!");
            return chartData;
        }
        if (StringUtils.isEmpty((String)queryMetrics)) {
            this.logError("not input metrics!");
            return chartData;
        }
        if (StringUtils.isEmpty((String)valueType) || !valueType.equals("int") && !valueType.equals("float")) {
            log.error("input valueType={},not int and float", (Object)valueType);
            return chartData;
        }
        if (StringUtils.isEmpty((String)unit)) {
            this.logError("not input unit!");
            return chartData;
        }
        if (StringUtils.isEmpty((String)unitExp)) {
            unitExp = "/1";
        }
        String finalExp = unitExp;
        chartData.setUnit(unit);
        List<String> legendList = Collections.singletonList(legend);
        ArrayList<String> xData = new ArrayList<String>(16);
        HashMap<String, List<Object>> yData = new HashMap<String, List<Object>>(1);
        try {
            MetricsCondition condition = new MetricsCondition();
            if (StringUtils.isNotEmpty((String)instanceId) && StringUtils.isNotEmpty((String)queryMetrics) && StringUtils.isNotEmpty((String)start) && StringUtil.isNotEmpty((String)end)) {
                condition.setInstanceId(instanceId);
                condition.setMetrics(queryMetrics);
                condition.setStart(condition.stringToDate(start));
                condition.setPageSize(10000);
                condition.setEnd(condition.stringToDate(end));
                IMetricsEsDaoImpl dao = new IMetricsEsDaoImpl();
                ArrayList dataY = new ArrayList(16);
                List<MetricsResultData> dataList = dao.queryMetricsRange(condition);
                dataList.forEach(metricsData -> {
                    String time = dateFormatForView.format(metricsData.getTimestamp());
                    double metricsValue = metricsData.getVal();
                    try {
                        String tranExp = metricsValue + finalExp;
                        metricsValue = InstanceMetricsHandler.evaluateExpression(tranExp);
                    }
                    catch (ScriptException se) {
                        log.error("Query metrics={},The unit conversion expression of {} is incorrect.", (Object)queryMetrics, (Object)finalExp);
                    }
                    float floatVal = (float)metricsValue;
                    xData.add(time);
                    if (valueType.equals("int")) {
                        long value = Math.round(metricsValue);
                        dataY.add(value);
                    } else if (valueType.equals("float")) {
                        String formatValue = MetricsUtils.format(floatVal, null);
                        dataY.add(formatValue);
                    }
                    yData.put(legend, dataY);
                });
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        chartData.setxData(xData);
        chartData.setLegend(legendList);
        chartData.setyData(yData);
        chartData.setMetrics(queryMetrics);
        return chartData;
    }

    private static double evaluateExpression(String expression) throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("js");
        String result = InstanceMetricsHandler.isMathExpression(expression) ? engine.eval(expression) : expression;
        return Double.parseDouble(result.toString());
    }

    private static boolean isMathExpression(String input) {
        String mathExpressionRegex = "^(?>[\\d\\s()+\\-*/]+)$";
        return input.matches(mathExpressionRegex);
    }

    private void logError(String msg) {
        log.error(msg);
    }
}

