/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.cpu;

import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.dashboard.metrics.base.TextChartData;
import kd.bos.eye.api.dashboard.metrics.commom.DashboardEsClientImpl;
import kd.bos.eye.api.dashboard.metrics.commom.MetricsUtils;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class CPUMaxLoadMetricsHandler
implements IMetricsData {
    private static final Log log = LogFactory.getLog(CPUMaxLoadMetricsHandler.class);
    private static final String TIMESTAMP = "timestamp";
    private static final String INSTANCE_KEY = "instanceId";
    private static final String APP_NAME_KEY = "appName";
    private static final String PERCENT_INTEGER_KEY = "percent";
    private static final String UNIT_TEXT = "unit";
    public static final String METRIC_INDEX_KEYWORD = "-metrics-";
    private static String[] includeFieldsResult = new String[]{"appName", "ip", "kd.metrics.jvm.system.cpuLoadAvg.mean"};
    private static final NumberFormat nt = NumberFormat.getPercentInstance();

    @Override
    public TextChartData query(BaseQueryParameter parameter) {
        TextChartData textChartData = new TextChartData();
        String usedPercent = "";
        String redisInstance = "";
        String instance = parameter.getExtensionParameter().get(INSTANCE_KEY);
        try {
            Map<String, String> dataMap = this.getData(parameter.getExtensionParameter().get(APP_NAME_KEY), parameter.getExtensionParameter().get(INSTANCE_KEY));
            textChartData.setText(dataMap.get(PERCENT_INTEGER_KEY));
            textChartData.setUnit("%(" + dataMap.get(UNIT_TEXT) + ")");
        }
        catch (Exception e) {
            log.error("Count Slow query error={}", (Object)e.getMessage());
        }
        return textChartData;
    }

    private Map<String, String> getData(String appName, String instanceId) {
        HashMap<String, String> map = new HashMap<String, String>();
        DashboardEsClientImpl esClient = new DashboardEsClientImpl();
        String indexPre = Instance.getClusterName().toLowerCase().concat(METRIC_INDEX_KEYWORD);
        Calendar now = Calendar.getInstance();
        Date end = now.getTime();
        now.add(13, -30);
        Date start = now.getTime();
        String[] index = MetricsUtils.getIndices(indexPre, start, end);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(index);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.size(1);
        sourceBuilder.trackTotalHits(true);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty((String)instanceId)) {
            boolQuery.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"instanceId.keyword", (Object)instanceId));
        }
        if (StringUtils.isNotEmpty((String)appName)) {
            boolQuery.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"appName.keyword", (Object)appName));
        }
        boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)start.getTime()).lte((Object)end.getTime()));
        String[] excludeFieldsResult = new String[]{};
        sourceBuilder.fetchSource(includeFieldsResult, excludeFieldsResult);
        sourceBuilder.sort("kd.metrics.jvm.system.cpuLoadAvg.mean", SortOrder.DESC);
        searchRequest.source(sourceBuilder).indices(index).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        sourceBuilder.postFilter((QueryBuilder)boolQuery);
        try {
            SearchHit[] searchHits;
            SearchResponse searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
            if (searchResponse.status().getStatus() == 200 && (searchHits = searchResponse.getHits().getHits()).length > 0) {
                Map data = searchHits[0].getSourceAsMap();
                Object val = data.get("kd.metrics.jvm.system.cpuLoadAvg.mean");
                double usage = 0.0;
                if (val != null) {
                    usage = (Double)val;
                }
                String ipAddr = (String)data.get("ip");
                map.put(PERCENT_INTEGER_KEY, String.valueOf(Math.round(usage)));
                if (StringUtils.isNotEmpty((String)appName)) {
                    map.put(UNIT_TEXT, appName + "-" + ipAddr);
                } else {
                    map.put(UNIT_TEXT, ipAddr);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return map;
    }
}

