/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.memory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.dashboard.metrics.base.TextChartData;
import kd.bos.eye.api.dashboard.metrics.commom.DashboardEsClientImpl;
import kd.bos.eye.api.dashboard.metrics.commom.MetricsUtils;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class MemoryMaxLoadMetricsHandler
implements IMetricsData {
    private static final Log log = LogFactory.getLog(MemoryMaxLoadMetricsHandler.class);
    private static final String TIMESTAMP = "timestamp";
    private static final String INSTANCE_KEY = "instanceId";
    private static final String APP_NAME_KEY = "appName";
    private static final String PERCENT_INTEGER_KEY = "percent";
    private static final String UNIT_TEXT = "unit";
    public static final String METRIC_INDEX_KEYWORD = "-metrics-";
    private static String[] includeFieldsResult = new String[]{"appName", "ip", "kd.metrics.jvm.memory.heap.used", "kd.metrics.jvm.memory.heap.max"};

    @Override
    public TextChartData query(BaseQueryParameter parameter) {
        TextChartData textChartData = new TextChartData();
        String usedPercent = "";
        String redisInstance = "";
        String instance = parameter.getExtensionParameter().get(INSTANCE_KEY);
        try {
            Map<String, String> dataMap = this.getData(parameter.getExtensionParameter().get(APP_NAME_KEY), parameter.getExtensionParameter().get(INSTANCE_KEY));
            textChartData.setText(dataMap.get(PERCENT_INTEGER_KEY));
            textChartData.setUnit("%(" + dataMap.get(UNIT_TEXT) + ")");
        }
        catch (Exception e) {
            log.error("Count Slow query error={}", (Object)e.getMessage());
        }
        return textChartData;
    }

    private Map<String, String> getData(String appName, String instanceId) {
        HashMap<String, String> map = new HashMap<String, String>();
        DashboardEsClientImpl esClient = new DashboardEsClientImpl();
        String indexPre = Instance.getClusterName().toLowerCase().concat(METRIC_INDEX_KEYWORD);
        Calendar now = Calendar.getInstance();
        Date end = now.getTime();
        now.add(13, -30);
        Date start = now.getTime();
        String[] index = MetricsUtils.getIndices(indexPre, start, end);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(index);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.size(1);
        sourceBuilder.trackTotalHits(true);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty((String)instanceId)) {
            boolQuery.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"instanceId.keyword", (Object)instanceId));
        }
        if (StringUtils.isNotEmpty((String)appName)) {
            boolQuery.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"appName.keyword", (Object)appName));
        }
        boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP).gte((Object)start.getTime()).lte((Object)end.getTime()));
        String[] excludeFieldsResult = new String[]{};
        sourceBuilder.fetchSource(includeFieldsResult, excludeFieldsResult);
        sourceBuilder.sort("kd.metrics.jvm.memory.heap.used", SortOrder.DESC);
        searchRequest.source(sourceBuilder).indices(index).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        sourceBuilder.postFilter((QueryBuilder)boolQuery);
        try {
            SearchHit[] searchHits;
            int oneG = 0x40000000;
            SearchResponse searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
            if (searchResponse.status().getStatus() == 200 && (searchHits = searchResponse.getHits().getHits()).length > 0) {
                Map data = searchHits[0].getSourceAsMap();
                double usage = 0.0;
                double usedg = 0.0;
                double used = Double.parseDouble(data.get("kd.metrics.jvm.memory.heap.used").toString());
                usedg = used / (double)oneG;
                double max = Double.parseDouble(data.get("kd.metrics.jvm.memory.heap.max").toString());
                double maxg = max / (double)oneG;
                usage = used / max;
                String ipAddr = (String)data.get("ip");
                BigDecimal usagebg = BigDecimal.valueOf(usage * 100.0).setScale(0, RoundingMode.UP);
                map.put(PERCENT_INTEGER_KEY, String.valueOf(usagebg.intValue()));
                BigDecimal maxgB = BigDecimal.valueOf(maxg).setScale(1, RoundingMode.UP);
                BigDecimal usedGb = BigDecimal.valueOf(usedg).setScale(2, RoundingMode.UP);
                StringBuilder unitSB = new StringBuilder();
                unitSB.append(usedGb.doubleValue()).append("G/").append(maxgB.doubleValue()).append("G").append("|");
                if (StringUtils.isNotEmpty((String)appName)) {
                    unitSB.append(appName).append("-");
                }
                unitSB.append(ipAddr);
                map.put(UNIT_TEXT, unitSB.toString());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return map;
    }
}

