/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.redis;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.eye.api.dashboard.metrics.base.TextChartData;
import kd.bos.eye.api.dashboard.metrics.commom.MetricsUtils;
import kd.bos.eye.api.redis.RedisRequest;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class RedisMetricsHandler
implements IMetricsData {
    private static final Log log = LogFactory.getLog(RedisMetricsHandler.class);
    private static final String INSTANCE_KEY = "instance";
    private static final String PERCENT_INTEGER_KEY = "percent";
    private static final String UNIT_TEXT = "unit";
    private static final NumberFormat nt = NumberFormat.getPercentInstance();

    @Override
    public TextChartData query(BaseQueryParameter parameter) {
        TextChartData textChartData = new TextChartData();
        String usedPercent = "";
        String redisInstance = "";
        String instance = parameter.getExtensionParameter().get(INSTANCE_KEY);
        try {
            Map<String, String> dataMap = this.getData(instance);
            textChartData.setText(dataMap.get(PERCENT_INTEGER_KEY));
            textChartData.setUnit("%(" + dataMap.get(UNIT_TEXT) + ")");
        }
        catch (Exception e) {
            log.error("Count Slow query error={}", (Object)e.getMessage());
        }
        return textChartData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getData(String instance) {
        HashMap<String, String> map = new HashMap<String, String>();
        RedisRequest params = new RedisRequest();
        params.setKv("");
        params.setNode("");
        Set<String> redisEndpoints = this.getRedisUrls(instance);
        if (redisEndpoints.isEmpty()) return map;
        Iterator<String> iterator = redisEndpoints.iterator();
        while (iterator.hasNext()) {
            String url = iterator.next();
            if (url.indexOf(instance) < 0) continue;
            try (JedisClient client = RedisFactory.getJedisClient((String)url);){
                List mapClient = client.getRedisInfo();
                long maxMemory = 0L;
                String maxMemoryHuman = "";
                long usedMemory = 0L;
                String usedMemoryHuman = "";
                for (Map m : mapClient) {
                    if (m.containsKey("maxmemory")) {
                        maxMemory = Long.parseLong(((String)m.get("maxmemory")).replaceAll("\r", ""));
                    }
                    if (m.containsKey("maxmemory_human")) {
                        maxMemoryHuman = ((String)m.get("maxmemory_human")).replaceAll("\r", "");
                    }
                    if (m.containsKey("used_memory")) {
                        usedMemory = Long.parseLong(((String)m.get("used_memory")).replaceAll("\r", ""));
                    }
                    if (!m.containsKey("used_memory_human")) continue;
                    usedMemoryHuman = ((String)m.get("used_memory_human")).replaceAll("\r", "");
                }
                nt.setMinimumFractionDigits(0);
                float floatData = maxMemory == 0L ? 0.0f : (float)usedMemory / (float)maxMemory * 100.0f;
                int percent = MetricsUtils.floatToInt(floatData);
                String percentInt = String.valueOf(percent);
                String text = usedMemoryHuman + "/" + maxMemoryHuman;
                map.put(PERCENT_INTEGER_KEY, percentInt);
                map.put(UNIT_TEXT, text);
                client.close();
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return map;
    }

    private Set<String> getRedisUrls(String instance) {
        HashSet<String> Urls = new HashSet<String>();
        try {
            Class<?> redisfactorycl = Class.forName("kd.bos.redis.RedisFactory");
            Field filed = redisfactorycl.getDeclaredField("poolMap");
            AccessibleObject.setAccessible(new AccessibleObject[]{filed}, true);
            Map poolmap = (Map)filed.get(redisfactorycl);
            poolmap.forEach((k, v) -> {
                if (k.indexOf(instance) > -1) {
                    Urls.add((String)k);
                    return;
                }
            });
        }
        catch (Exception e) {
            return Urls;
        }
        return Urls;
    }
}

