/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.slowquery;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.eye.api.dashboard.metrics.base.TextChartData;
import kd.bos.eye.api.log.LogQuery;
import kd.bos.eye.api.log.LogQueryFactory;
import kd.bos.eye.api.log.LogQueryUtils;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CountMetricsHandler
implements IMetricsData {
    private static final Log log = LogFactory.getLog(CountMetricsHandler.class);
    private final DateTimeFormatter formatter = LogQueryUtils.getDateTimeFormatter();
    private static final String SLOW_TYPE = "type";
    private static final String SLOW_TYPE_KEY = "slowQueryType";
    private static final String SLOW_CLASS = "kd.bos.slowlog.SlowLogger";
    private static final String CLASS_NAME = "className";

    @Override
    public TextChartData query(BaseQueryParameter parameter) {
        int count = 0;
        TextChartData textChartData = new TextChartData();
        try {
            count = this.count(parameter);
        }
        catch (Exception e) {
            log.error("Count Slow query error={}", (Object)e.getMessage());
        }
        textChartData.setText(String.valueOf(count));
        textChartData.setUnit("");
        return textChartData;
    }

    private int count(BaseQueryParameter parameter) {
        int count = 0;
        String start = parameter.getStartTime();
        String end = parameter.getEndTime();
        String type = parameter.getExtensionParameter().get(SLOW_TYPE);
        String appName = parameter.getExtensionParameter().get("appName");
        String instanceId = parameter.getExtensionParameter().get("instanceId");
        LocalDateTime beginTime = LocalDateTime.parse(start, this.formatter);
        LocalDateTime endTime = LocalDateTime.parse(end, this.formatter);
        HashMap<String, String> condition = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)type)) {
            if ("web".equals(type.toLowerCase(Locale.ENGLISH))) {
                condition.put(SLOW_TYPE_KEY, "SlowLogger-WEB");
            } else if ("rpc".equals(type.toLowerCase(Locale.ENGLISH))) {
                condition.put(SLOW_TYPE_KEY, "SlowLogger-RPC");
            } else if ("sql".equals(type.toLowerCase(Locale.ENGLISH))) {
                condition.put(SLOW_TYPE_KEY, "SlowLogger-JDBC");
            } else {
                condition.put(SLOW_TYPE_KEY, type);
            }
        }
        if (StringUtils.isNotEmpty((String)instanceId)) {
            condition.put("instanceId", instanceId);
        }
        if (StringUtils.isNotEmpty((String)appName)) {
            condition.put("appName", appName);
        }
        condition.put(CLASS_NAME, SLOW_CLASS);
        LogQuery query = LogQueryFactory.getLogQuery();
        count = query.countLogQuery(Date.from(beginTime.atZone(ZoneId.systemDefault()).toInstant()), Date.from(endTime.atZone(ZoneId.systemDefault()).toInstant()), condition);
        return count;
    }
}

