/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.datasource;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.db.datasource.DataSourceMXBeanImpl;
import kd.bos.eye.api.common.entity.KeyValueEntity;
import kd.bos.eye.httpserver.AbstractHttpHandler;

public class DataSourceApiHandler
extends AbstractHttpHandler {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        TabularData tabularData;
        Map<String, String> dataSourceMxBeanInfoMap;
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Map dataSourceMap = DataSourceFactory.dumpStatusMap((boolean)true);
        Map appDataSourceMap = (Map)dataSourceMap.get("appDataSources");
        if (appDataSourceMap != null) {
            ArrayList<KeyValueEntity> keyValueEntityList = new ArrayList<KeyValueEntity>(20);
            for (Map.Entry next : appDataSourceMap.entrySet()) {
                keyValueEntityList.add(new KeyValueEntity((String)next.getKey(), next.getValue()));
            }
            dataSourceMap.put("appDataSources", keyValueEntityList);
            dataMap.put("dataSource", dataSourceMap);
        }
        if ((dataSourceMxBeanInfoMap = this.tabularDataToMap(tabularData = DataSourceMXBeanImpl.get().getDataSourceTabularData())) != null) {
            ArrayList<KeyValueEntity> keyValueEntityList = new ArrayList<KeyValueEntity>(20);
            for (Map.Entry<String, String> next : dataSourceMxBeanInfoMap.entrySet()) {
                keyValueEntityList.add(new KeyValueEntity(next.getKey(), next.getValue()));
            }
            dataMap.put("dataSourceMXBean", keyValueEntityList);
        }
        response.put("code", 0);
        response.put("data", dataMap);
        response.put("msg", "success");
        String str = MAPPER.writeValueAsString(response);
        this.writeJson(str, exchange);
    }

    public Map<String, String> tabularDataToMap(TabularData tabularData) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (Object x : tabularData.values()) {
            CompositeData cd = (CompositeData)x;
            map.put((String)cd.get("key"), (String)cd.get("value"));
        }
        return map;
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

