/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.commons;

import java.text.Collator;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.dbmonitor.commons.MonitorDB;
import kd.bos.eye.api.dbmonitor.commons.Utils;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.util.MonitorLoginUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MonitorDBDao {
    private static final Log log = LogFactory.getLog(MonitorDBDao.class);

    public List<MonitorDB> getDBList() {
        ArrayList<MonitorDB> dbList = new ArrayList<MonitorDB>(2);
        try {
            List<MonitorDB> monitorDBList = this.getDBListFromDB();
            if (monitorDBList != null) {
                for (MonitorDB monitorDB : monitorDBList) {
                    if (null == Utils.getMonitorIDBInfo(monitorDB.getAddress())) {
                        this.delete(monitorDB);
                        continue;
                    }
                    dbList.add(monitorDB);
                }
                List<MonitorDB> unSavedDB = Utils.getNotSavedInMC(monitorDBList);
                if (unSavedDB.size() > 0) {
                    this.saveAndUpdateMonitorDBBatch(unSavedDB);
                }
            } else {
                dbList.addAll(Utils.getDBInfosFromDataSource());
                this.saveAndUpdateMonitorDBBatch(dbList);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        dbList.sort((o1, o2) -> {
            Collator com = Collator.getInstance(Locale.CHINA);
            return com.compare(o1.getType(), o2.getType());
        });
        return dbList;
    }

    private List<MonitorDB> getDBListFromDB() {
        ArrayList<MonitorDB> monitorDBList = null;
        String querySql = "select fid,fdbtype,fdbname,fdbaddress,fuser,fpsd from T_MONITOR_MONITOR_DB ";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, null));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        if (results != null && results.size() > 0) {
            monitorDBList = new ArrayList<MonitorDB>(results.size());
            for (Result result : results) {
                MonitorDB monitorDB = new MonitorDB();
                monitorDB.setId(result.getString("fid"));
                monitorDB.setType(result.getString("fdbtype"));
                monitorDB.setSysDBName(result.getString("fdbname"));
                monitorDB.setAddress(result.getString("fdbaddress"));
                monitorDB.setAccount(result.getString("fuser"));
                monitorDB.setPsd(result.getString("fpsd"));
                monitorDBList.add(monitorDB);
            }
        }
        return monitorDBList;
    }

    public MonitorDB getMonitorDB(String address) {
        List<MonitorDB> dbList = this.getDBList();
        for (MonitorDB monitorDB : dbList) {
            if (!monitorDB.getAddress().equals(address)) continue;
            monitorDB.setPsd(Encrypters.decode((String)monitorDB.getPsd()));
            return monitorDB;
        }
        return null;
    }

    public MonitorDB getMonitorDB(String address, String user) {
        List<MonitorDB> dbList = this.getDBList();
        for (MonitorDB monitorDB : dbList) {
            if (!monitorDB.getAddress().equals(address)) continue;
            Account account = AccountUtils.getAccountById((String)monitorDB.getAccountId());
            for (DBInstance instance : account.getDBInstanceList()) {
                if (!instance.getDbuser().equals(user)) continue;
                monitorDB.setPsd(Encrypters.decode((String)instance.getDbpassword()));
                break;
            }
            return monitorDB;
        }
        return null;
    }

    public List<MonitorDB> getMonitorDBList(List<String> addressList) {
        List<MonitorDB> dbList = this.getDBList();
        ArrayList<MonitorDB> result = new ArrayList<MonitorDB>();
        block0: for (String address : addressList) {
            for (MonitorDB monitorDB : dbList) {
                if (!monitorDB.getAddress().equals(address)) continue;
                monitorDB.setPsd(Encrypters.decode((String)monitorDB.getPsd()));
                result.add(monitorDB);
                continue block0;
            }
        }
        return result;
    }

    public void saveAndUpdateMonitorDB(MonitorDB dbInfo) {
        try {
            MonitorDB sourceDB = Utils.getMonitorIDBInfo(dbInfo.getAddress());
            if (sourceDB != null) {
                dbInfo.setPsd(MonitorLoginUtils.getDecryptPassword("DBConfig", dbInfo.getPsd()));
                dbInfo.setPsd(Encrypters.encode((String)dbInfo.getPsd()));
                dbInfo.setJdbcDriver(sourceDB.getJdbcDriver());
                String updateSql = "update T_MONITOR_MONITOR_DB set fuser = ?, fpsd = ? where fdbtype = ? and fdbaddress = ?";
                DBRequest dbRequest = new DBRequest();
                ArrayList<String> paramList = new ArrayList<String>(3);
                paramList.add(dbInfo.getAccount());
                paramList.add(dbInfo.getPsd());
                paramList.add(dbInfo.getType());
                paramList.add(dbInfo.getAddress());
                dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, paramList));
                MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
            }
        }
        catch (Exception e) {
            log.error("Monitor db save or add error:{}", (Object)e.getMessage(), (Object)e);
            throw new KDException(e.getMessage());
        }
    }

    public void saveAndUpdateMonitorDBBatch(List<MonitorDB> dbInfos) {
        ArrayList<DBRequest> requests = new ArrayList<DBRequest>(dbInfos.size());
        for (MonitorDB dbInfo : dbInfos) {
            String insertSql = "insert into T_MONITOR_MONITOR_DB values(?,?,?,?,?,?,?,?,?,?,?)";
            ArrayList<Object> monitorDbParamList = new ArrayList<Object>(6);
            monitorDbParamList.add(ID.genLongId());
            monitorDbParamList.add(dbInfo.getType());
            monitorDbParamList.add(dbInfo.getSysDBName());
            monitorDbParamList.add(" ");
            monitorDbParamList.add(dbInfo.getAccount());
            monitorDbParamList.add(dbInfo.getPsd());
            monitorDbParamList.add(dbInfo.getAddress());
            monitorDbParamList.add(" ");
            monitorDbParamList.add(" ");
            LocalDateTime time = LocalDateTime.now();
            monitorDbParamList.add(time);
            monitorDbParamList.add(time);
            DBRequest dbRequest = new DBRequest();
            dbRequest.setInsertRequest(new DBRequest.InsertRequest(insertSql, monitorDbParamList));
            requests.add(dbRequest);
        }
        MetadataFactory.getStatement().executeInsertBatch(requests);
    }

    public void createMonitorDB(MonitorDB dbInfo) {
    }

    public void delete(MonitorDB db) {
        String deleteSql = "delete from T_MONITOR_MONITOR_DB where fid = ?";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, Collections.singletonList(db.getId())));
        MetadataFactory.getStatement().executeDelete((Request)dbRequest);
    }
}

