/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.commons;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.dbmonitor.commons.MonitorDB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

public class Utils {
    public static final String CACHE_KEY = "DBConfig";
    private static final Log log = LogFactory.getLog(Utils.class);
    public static final String DB_LIST_KEY = "dbList";
    public static final String SUPPORT_DB_LIST_KEY = "sqlSnapshotSupportDB";
    public static final int SUCCESS_STATUS_CODE = 0;

    public static String getSupportDbTypes() {
        String supportDBTypes = "";
        StringBuilder json = new StringBuilder();
        try (InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("monitor-db-support.json");
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                json.append(line);
            }
            Map map = (Map)JSONObject.parseObject((String)json.toString(), Map.class);
            if (map.containsKey(SUPPORT_DB_LIST_KEY)) {
                supportDBTypes = (String)map.get(SUPPORT_DB_LIST_KEY);
            }
        }
        catch (Exception e) {
            log.error("monitor db info init to cache error", (Object)e.getMessage());
        }
        return supportDBTypes;
    }

    private static MonitorDB getMonitorDB(String url) {
        String[] dbTypes;
        MonitorDB dbInfo = new MonitorDB();
        String supportDB = Utils.getSupportDbTypes();
        for (String dbType : dbTypes = supportDB.split(",")) {
            if (!url.toLowerCase().split(":")[3].split("=")[1].startsWith(dbType.toLowerCase(Locale.ENGLISH))) continue;
            if (dbType.equals("Oracle")) {
                String[] ddd = url.split("/");
                dbInfo.setSysDBName(ddd[1]);
                dbInfo.setAddress(ddd[0].split("@")[1]);
                dbInfo.setJdbcDriver(ddd[0].split("@")[0].split(":")[2]);
            } else {
                String[] infos = url.split(":");
                dbInfo.setJdbcDriver(infos[2]);
                if (NetAddressUtils.isPreferIPv6() && url.contains("//[")) {
                    int ipv6Start = url.indexOf("//[");
                    int ipv6End = url.indexOf("]");
                    String ipv6 = "";
                    if (ipv6Start != -1 && ipv6End != -1) {
                        ipv6 = url.substring(ipv6Start + 2, ipv6End + 1);
                    }
                    int portStart = url.indexOf(":", ipv6End) + 1;
                    int portEnd = url.indexOf("/", portStart);
                    String port = "";
                    if (portStart != -1 && portEnd != -1) {
                        port = url.substring(portStart, portEnd);
                    }
                    dbInfo.setAddress(ipv6 + ":" + port);
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append(infos[6].replace("/", ""));
                    for (int i = 0; i < infos.length; ++i) {
                        if (infos[7 + i].contains("/")) {
                            sb.append(":").append(infos[7 + i].split("/")[0]);
                            break;
                        }
                        sb.append(":").append(infos[7 + i]);
                    }
                    dbInfo.setAddress(sb.toString());
                }
                switch (dbType) {
                    case "MySQL": {
                        dbInfo.setSysDBName("information_schema");
                        break;
                    }
                    case "PostgreSQL": {
                        dbInfo.setSysDBName("postgres");
                        break;
                    }
                    default: {
                        dbInfo.setSysDBName("unKnown");
                    }
                }
            }
            dbInfo.setType(dbType);
        }
        return dbInfo;
    }

    public static List<MonitorDB> getDBInfosFromDataSource() {
        ArrayList<MonitorDB> dbs = new ArrayList<MonitorDB>(3);
        List urls = DataSourceFactory.getAllDBInstanceDataSource();
        for (int i = 0; i < urls.size(); ++i) {
            MonitorDB dbInfo = Utils.getMonitorDB(((String[])urls.get(i))[0]);
            if (!StringUtils.isNotEmpty((String)dbInfo.getAddress())) continue;
            dbInfo.setAccount(((String[])urls.get(i))[1]);
            dbInfo.setPsd(Encrypters.encode((String)((String[])urls.get(i))[2]));
            dbInfo.setTenant(((String[])urls.get(i))[3]);
            dbInfo.setAccountId(((String[])urls.get(i))[4]);
            dbs.add(dbInfo);
        }
        return dbs;
    }

    public static MonitorDB getMonitorIDBInfo(String address) {
        List<MonitorDB> dbs = Utils.getDBInfosFromDataSource();
        for (MonitorDB monitorDB : dbs) {
            if (!monitorDB.getAddress().equals(address)) continue;
            return monitorDB;
        }
        return null;
    }

    public static List<MonitorDB> getNotSavedInMC(List<MonitorDB> monitorDBList) {
        ArrayList<MonitorDB> list = new ArrayList<MonitorDB>(5);
        List<MonitorDB> dataSources = Utils.getDBInfosFromDataSource();
        for (MonitorDB db : dataSources) {
            boolean notIn = true;
            for (MonitorDB monitorDB : monitorDBList) {
                if (!db.getAddress().equals(monitorDB.getAddress())) continue;
                monitorDB.setJdbcDriver(db.getJdbcDriver());
                notIn = false;
                break;
            }
            if (!notIn) continue;
            list.add(db);
        }
        return list;
    }
}

