/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.handler;

import com.alibaba.fastjson.JSONArray;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import kd.bos.eye.api.dbmonitor.ExplainExecutorFactory;
import kd.bos.eye.api.dbmonitor.commons.MonitorDB;
import kd.bos.eye.api.dbmonitor.commons.MonitorDBDao;
import kd.bos.eye.api.dbmonitor.entity.req.ExplainReq;
import kd.bos.eye.api.dbmonitor.entity.vo.ExplainParam;
import kd.bos.eye.api.dbmonitor.service.SqlExplainExecutor;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;

public class ExplainHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(ExplainHandler.class);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse<JSONArray> response = new ApiResponse<JSONArray>();
        JSONArray result = new JSONArray(5);
        try {
            ExplainReq postParam = ExchangeVueUtils.parseJsonFromPost(exchange, ExplainReq.class);
            String sql = postParam.getSql();
            String dbType = postParam.getDbType();
            String dbAddress = postParam.getAddress();
            String schema = postParam.getSchema();
            String user = postParam.getUser();
            MonitorDBDao monitorDBDao = new MonitorDBDao();
            MonitorDB dbInfo = dbType.equals("Oracle") ? monitorDBDao.getMonitorDB(dbAddress, user) : monitorDBDao.getMonitorDB(dbAddress);
            if (dbInfo != null) {
                SqlExplainExecutor executor = ExplainExecutorFactory.getInstance().create(dbType);
                ExplainParam param = new ExplainParam();
                param.setAccount(dbInfo.getAccount());
                param.setType(dbInfo.getType());
                param.setAddress(dbInfo.getAddress());
                param.setJdbcDriver(dbInfo.getJdbcDriver());
                param.setPsd(dbInfo.getPsd());
                param.setSql(sql);
                param.setSchema(schema);
                result = executor.explain(param);
                response.setMsg("success");
            } else {
                response.setMsg(String.format("get db instance failed: %s/%s", dbAddress, schema));
            }
        }
        catch (Exception e) {
            response.setMsg("error");
            log.error("Explain sql:{}", (Object)e.getMessage());
        }
        response.setCode(0);
        response.setData(result);
        this.writeJson(JSONUtils.toString(response), exchange);
    }
}

